import moment from 'moment';
import { BaseExternalDeploymentEvent, ConnectionServer, DeploymentState, ExternalDeployment } from '../external-deployment.types';

export const baseExternalDeploymentEventMock: BaseExternalDeploymentEvent = {
    applicationName: 'application',
    applicationPath: 'application/path',
    applicationUid: '12',
    destination: 'Environment',
    destinationUid: '24',
    namespace: 'namespace',
};

export const deploymentStateWithoutDateTimeMock: DeploymentState = {
    ...baseExternalDeploymentEventMock,
    deploymentStatus: 'DONE',
    deploymentType: 'INITIAL',
    destination: 'Environment',
    user: 'admin',
    versionTag: { label: '1.0' },
};

export const deploymentStateMock: DeploymentState = {
    ...deploymentStateWithoutDateTimeMock,
    lastChangeTime: moment().toDate(),
};

export const connectionServerMock: ConnectionServer = {
    id: 'Configuration/Xl Deploy',
    name: 'Xl Deploy',
    type: 'xldeploy.XLDeployServer',
    url: 'http://localhost:4516',
};

export const connectionServersMock = new Map(Object.entries({ 12: connectionServerMock }));

export const externalDeploymentMock: ExternalDeployment = {
    applicationName: 'application',
    applicationPath: 'application/path',
    applicationUid: '12',
    endpointId: '12',
    state: deploymentStateMock,
    statusGroup: 'success',
};
