export declare type PillStatus = 'success' | 'error' | 'warning' | 'in-progress' | 'default';

export interface VersionState {
    label: string;
    state?: string;
}

export interface DeploymentState {
    deploymentStatus: string;
    deploymentType: string;
    destination: string;
    lastChangeTime?: Date;
    namespace: string;
    user: string;
    versionTag: VersionState;
}

export interface ExternalDeployment {
    applicationName: string;
    applicationPath: string;
    applicationUid: string;
    endpointId: string;
    state: DeploymentState;
    statusGroup: PillStatus;
}

export interface ConnectionServer {
    id: string;
    name: string;
    type: string;
    url: string;
}

export interface ExternalDeploymentEvent {
    applicationUid: string;
    destinationUid: string;
}

export interface BaseExternalDeploymentEvent extends ExternalDeploymentEvent {
    applicationName: string;
    applicationPath: string;
    destination: string;
    destinationUid: string;
    namespace: string;
}

export interface CreateStatusEvent extends BaseExternalDeploymentEvent {
    statusGroup: string;
    versionTag: VersionState;
}

export interface DeleteStatusEvent extends BaseExternalDeploymentEvent {
    versionTag: VersionState;
}

export interface UpdateStatusEvent extends BaseExternalDeploymentEvent {
    state: DeploymentState;
    statusGroup: PillStatus;
}

export interface EndpointExternalDeploymentEvent<T extends ExternalDeploymentEvent> {
    endpointId: string;
    state: T;
}
