import React from 'react';
import { ReactWrapper } from 'enzyme';
import noop from 'lodash/noop';
import { mountWithStoreAndTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FilterApplications } from './filter-applications-component';
import { deployServerMock, mockDeployWebhookSource } from '../../../__mocks__/external-deployments.mocks';
import { folderExternalDeployments, FolderExternalDeploymentsState, initialState } from '../../../ducks/external-deployments.reducer';
import { getFilterCardTitle, getServerIcon } from '../../../helper/utils';
import { IMG_SRC } from '../../../constants';

const { loadWebhookSourceFilters } = folderExternalDeployments.actions;
const dispatch = jest.fn();

describe('FilterApplications component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        onCancel: () => noop(),
        onFilterBack: () => noop(),
        onSave: () => noop(),
        server: deployServerMock,
        webhookSource: mockDeployWebhookSource,
    };
    const defaultState = {
        ...initialState,
    };
    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<FilterApplications {...defaultProps} />, dispatch, { folderExternalDeployments: state });
        expect(dispatch).toBeCalledWith(loadWebhookSourceFilters(mockDeployWebhookSource.id!));
    };

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    const searchDotCard = (selector: string) => wrapper.find(`.filter-applications ${selector}`);

    it('should show the header', () => {
        expect(searchDotCard('.dot-typography').at(0).text()).toStrictEqual('Map folders');
    });

    it('should show folder filters autocomplete', () => {
        expect(searchDotCard('.folders-filter').at(0).text()).toContain('Choose folders');
        expect(searchDotCard('.folders-filter').at(0).text()).toContain('Map folders to display applications from');
    });

    it('should show server card', () => {
        expect(searchDotCard('.filter-card').at(0).text()).toContain(getFilterCardTitle(deployServerMock.type!));
        expect(searchDotCard('.filter-card').at(0).text()).toContain(deployServerMock.url);
        expect(searchDotCard('.filter-card img').at(0).props().src).toStrictEqual(getServerIcon(deployServerMock.type!));
    });

    it('should show webhook source card', () => {
        expect(searchDotCard('.filter-card').at(1).text()).toContain(mockDeployWebhookSource.title);
        expect(searchDotCard('.filter-card img').at(1).props().src).toStrictEqual(IMG_SRC.webhookSource);
    });

    it('should show buttons', () => {
        expect(searchDotCard('.dot-button button').at(0).text()).toStrictEqual('Back');
        expect(searchDotCard('.dot-button button').at(1).text()).toStrictEqual('Cancel');
        expect(searchDotCard('.dot-button button').at(2).text()).toStrictEqual('Done');
    });
});
