package com.xebialabs.xlrelease.api.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalDeploymentView {
    private Integer count = 0;
    private Map<Integer, ConnectionServerView> connectionServers = new HashMap<>();
    private List<ExternalDeploymentDataView> externalDeployments = new ArrayList<>();
    private List<String> errors = new ArrayList<>();
    private List<String> disconnectedServers = new ArrayList<>();

    public static ExternalDeploymentView create(Integer count,
                                                Map<Integer, ConnectionServerView> connectionServers,
                                                List<ExternalDeploymentDataView> statuses,
                                                List<String> errors,
                                                List<String> disconnectedServers) {
        ExternalDeploymentView view = new ExternalDeploymentView();
        view.count = count;
        view.setConnectionServers(connectionServers);
        view.setExternalDeployments(statuses);
        view.setErrors(errors);
        view.setDisconnectedServers(disconnectedServers);
        return view;
    }

    public Map<Integer, ConnectionServerView> getConnectionServers() {
        return connectionServers;
    }

    public void setConnectionServers(Map<Integer, ConnectionServerView> connectionServers) {
        this.connectionServers = connectionServers;
    }

    public List<ExternalDeploymentDataView> getExternalDeployments() {
        return externalDeployments;
    }

    public void setExternalDeployments(List<ExternalDeploymentDataView> externalDeployments) {
        this.externalDeployments = externalDeployments;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public List<String> getErrors() {
        return errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public List<String> getDisconnectedServers() {
        return disconnectedServers;
    }

    public void setDisconnectedServers(List<String> disconnectedServers) {
        this.disconnectedServers = disconnectedServers;
    }
}
