package com.xebialabs.xlrelease.status.webhook.events

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.webhooks.consumers.BaseProcessor

import java.util.{List => JList}
import scala.beans.BeanProperty

@Metadata(virtual = true, label = "Status Webhook Event Source abstract type")
class StatusWebhookEventSource extends BaseProcessor {

  @BeanProperty
  @Property(hidden = true, required = false, label="Filter script location")
  var filterScript: String = ""

  @BeanProperty
  @Property(hidden = true, required = false, label="Script location")
  var mapScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Classpath location of the status data Jython script")
  var statusScript: String = "StatusScript.py"

  @BeanProperty
  @Property(label = "Source server", category = "Server connection", required = true)
  var sourceServer: StatusHttpConnection = _

  @BeanProperty
  @Property(asContainment = true, required = false, description = "Filter by folders")
  var filteredFolders: JList[String] = _
}
