/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector.gitlab;

import com.google.common.net.UrlEscapers;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.HttpClientRequest$;
import com.xebialabs.xlrelease.versioning.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmHttpClientWrapper;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommit;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommitAction;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommitResponse;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabProjectResponse;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabTree;
import java.io.Serializable;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\b\u0010\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006Y\u0001!\t&\f\u0005\u0006u\u0001!\tf\u000f\u0005\u00065\u0002!\tf\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006I\u0002!I!\u001a\u0005\u0006_\u0002!I\u0001\u001d\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H\t\u0011r)\u001b;MC\n\u001c6-\\\"p]:,7\r^8s\u0015\t\u0001\u0012#\u0001\u0004hSRd\u0017M\u0019\u0006\u0003%M\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005Q)\u0012aA:d[*\u0011acF\u0001\u000bm\u0016\u00148/[8oS:<'B\u0001\r\u001a\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\u0005j\u0011!E\u0005\u0003EE\u00111CU3ti\u0006\u0003\u0018nU2n\u0007>tg.Z2u_J\faaY8oM&<\u0007CA\u0013'\u001b\u0005y\u0011BA\u0014\u0010\u0005a9\u0015\u000e\u001e'bEN\u001bWnQ8o]\u0016\u001cGo\u001c:D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)Z\u0003CA\u0013\u0001\u0011\u0015\u0019#\u00011\u0001%\u00039!Xm\u001d;SKB|7/\u001b;pef,\u0012A\f\t\u0004_Q2T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001B;uS2T\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kA\u00121\u0001\u0016:z!\t9\u0004(D\u00013\u0013\tI$G\u0001\u0003V]&$\u0018\u0001D2p[6LG/\u00118e)\u0006<G\u0003\u0002\u001fI\u001bJ\u00032a\f\u001b>!\tqTI\u0004\u0002@\u0007B\u0011\u0001IM\u0007\u0002\u0003*\u0011!)H\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\u001a\t\u000b%#\u0001\u0019\u0001&\u0002\u000b\tdwNY:\u0011\u0005\u0001Z\u0015B\u0001'\u0012\u0005\u0015\u0011En\u001c2t\u0011\u0015qE\u00011\u0001P\u0003)\u0019w.\\7ji&sgm\u001c\t\u0003AAK!!U\t\u0003'Y\u000bG.\u001b3bi\u0016$7i\\7nSRLeNZ8\t\u000bM#\u0001\u0019\u0001+\u0002\tU\u001cXM\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/^\ta\u0001Z8nC&t\u0017BA-W\u0005-)6/\u001a:Qe>4\u0017\u000e\\3\u0002\u001bQ\fwMT8u!J,7/\u001a8u)\ta\u0006\rE\u00020iu\u0003\"a\u000e0\n\u0005}\u0013$a\u0002\"p_2,\u0017M\u001c\u0005\u0006C\u0016\u0001\r!P\u0001\u0004i\u0006<\u0017\u0001D2sK\u0006$XM\u0011:b]\u000eDG#\u0001\u0018\u0002\u0019\r\u0014X-\u0019;f\u0007>lW.\u001b;\u0015\u0005\u0019T\u0007cA\u00185OB\u0011Q\u0005[\u0005\u0003S>\u0011AcR5u\u0019\u0006\u00147i\\7nSR\u0014Vm\u001d9p]N,\u0007\"B6\b\u0001\u0004a\u0017a\u0003:fcV,7\u000f\u001e\"pIf\u0004\"!J7\n\u00059|!\u0001D$ji2\u000b'mQ8n[&$\u0018!C2sK\u0006$X\rV1h)\u0015\t\u0018\u0011BA\u0007!\ryCG\u001d\t\u0004gjdX\"\u0001;\u000b\u0005U4\u0018\u0001\u00025uiBT!a\u001e=\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!_\u0001\u0004_J<\u0017BA>u\u00059\u0011Vm\u001d9p]N,WI\u001c;jif\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005!A.\u00198h\u0015\t\t\u0019!\u0001\u0003kCZ\f\u0017bAA\u0004}\n!ak\\5e\u0011\u0019\tY\u0001\u0003a\u0001{\u00059A/Y4OC6,\u0007BBA\b\u0011\u0001\u0007Q(A\u0002tQ\u0006\fac\u0019:fCR,Gi\u001d7SKF,Xm\u001d;BGRLwN\u001c\u000b\u0005\u0003+\ti\u0002\u0005\u00030i\u0005]\u0001cA\u0013\u0002\u001a%\u0019\u00111D\b\u0003%\u001dKG\u000fT1c\u0007>lW.\u001b;BGRLwN\u001c\u0005\u0006\u0013&\u0001\rAS\u0001\u001fGJ,\u0017\r^3BiR\f7\r[7f]R\u001c(+Z9vKN$\u0018i\u0019;j_:$B!a\t\u00028A!q\u0006NA\u0013!\u0019\t9#!\r\u0002\u00189!\u0011\u0011FA\u0017\u001d\r\u0001\u00151F\u0005\u0002g%\u0019\u0011q\u0006\u001a\u0002\u000fA\f7m[1hK&!\u00111GA\u001b\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005=\"\u0007C\u0003J\u0015\u0001\u0007!*\u0001\u0005sKB|g*Y7f+\u0005i\u0014!C;sY\u0016s7m\u001c3f)\ri\u0014\u0011\t\u0005\u0007\u0003\u0007b\u0001\u0019A\u001f\u0002\u000bY\fG.^3\u0002\u001b\u001dLG\u000fT1c%\u0016\fX/Z:u+\t\tI\u0005E\u0002!\u0003\u0017J1!!\u0014\u0012\u0005Q\u00196-\u001c%uiB\u001cE.[3oi^\u0013\u0018\r\u001d9fe\u0002")
public class GitLabScmConnector
extends RestApiScmConnector {
    private final GitLabScmConnectorConfig config;

    @Override
    public Try<BoxedUnit> testRepository() {
        return this.gitLabRequest().get(new StringBuilder(10).append("/projects/").append(this.repoName()).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$1 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$1).tried()).map((Function1 & Serializable)x$2 -> {
            GitLabScmConnector.$anonfun$testRepository$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this.createBranch().flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            Try try_ = this.createDslRequestAction(blobs).flatMap((Function1 & Serializable)dslCommitAction -> this.createAttachmentsRequestAction(blobs).flatMap((Function1 & Serializable)attachmentCommitAction -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                GitLabCommitAction gitLabCommitAction = dslCommitAction;
                return new GitLabCommit($this.config.branch(), commitInfo.message(), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)attachmentCommitAction.$colon$colon((Object)gitLabCommitAction)).asJavaCollection());
            }).flatMap((Function1 & Serializable)requestBody -> this.createCommit((GitLabCommit)requestBody).flatMap((Function1 & Serializable)gitCommitInfo -> this.createTag(commitInfo.tag().refName(), gitCommitInfo.id()).map((Function1 & Serializable)x$3 -> {
                ResponseEntity responseEntity = x$3;
                String string = gitCommitInfo.id();
                return string;
            })))));
            return try_;
        });
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this.gitLabRequest().get(new StringBuilder(27).append("/projects/").append(this.repoName()).append("/repository/tags/").append(tag).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GitLabScmConnector.$anonfun$tagNotPresent$1(x$5)));
    }

    public Try<BoxedUnit> createBranch() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ResponseEntity projectResponse = (ResponseEntity)this.gitLabRequest().get(new StringBuilder(10).append("/projects/").append(this.repoName()).toString()).doRequest(ClassTag$.MODULE$.apply(GitLabProjectResponse.class)).get();
            if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(projectResponse).isSuccessful()) {
                throw new TemplateVersioningException("Unable to retrieve default branch", null, projectResponse.getStatusCodeValue());
            }
            boolean exist = HttpClientRequest$.MODULE$.ResponseEntityExtension((ResponseEntity)this.gitLabRequest().get(new StringBuilder(31).append("/projects/").append(this.repoName()).append("/repository/branches/").append($this.config.branch()).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get()).isSuccessful();
            if (!exist) {
                ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("ref", ((GitLabProjectResponse)projectResponse.getBody()).default_branch()).addQueryParam("branch", $this.config.branch());
                String x$1 = new StringBuilder(30).append("/projects/").append(this.repoName()).append("/repository/branches").toString();
                Null$ x$2 = qual$1.post$default$2();
                ResponseEntity response = (ResponseEntity)qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
                if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    throw new TemplateVersioningException("Unable to create branch", null, response.getStatusCodeValue());
                }
            }
        });
    }

    private Try<GitLabCommitResponse> createCommit(GitLabCommit requestBody) {
        return this.gitLabRequest().post(new StringBuilder(29).append("/projects/").append(this.repoName()).append("/repository/commits").toString(), requestBody).doRequest(ClassTag$.MODULE$.apply(GitLabCommitResponse.class)).flatMap((Function1 & Serializable)x$6 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$6).checkResponse("Error occured while trying to commit on GitLab")).map((Function1 & Serializable)x$7 -> (GitLabCommitResponse)x$7.getBody());
    }

    private Try<ResponseEntity<Void>> createTag(String tagName, String sha) {
        ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("tag_name", tagName).addQueryParam("ref", sha);
        String x$1 = new StringBuilder(26).append("/projects/").append(this.repoName()).append("/repository/tags").toString();
        Null$ x$2 = qual$1.post$default$2();
        return qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$8 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$8).checkResponse("Error occurred while trying to create tag"));
    }

    private Try<GitLabCommitAction> createDslRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).get(new StringBuilder(28).append("/projects/").append(this.repoName()).append("/repository/files/").append(this.urlEncode(blobs.templateFilePath())).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
            HttpStatus httpStatus = response.getStatusCode();
            HttpStatus httpStatus2 = HttpStatus.UNAUTHORIZED;
            if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                throw new TemplateVersioningException("Unable to connect to the repository.", null, response.getStatusCodeValue());
            }
            return HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful();
        }).collect((PartialFunction)new Serializable(null, blobs){
            private static final long serialVersionUID = 0L;
            private final Blobs blobs$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                GitLabCommitAction gitLabCommitAction = true == A1 ? new GitLabCommitAction("update", this.blobs$2.templateFilePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64") : new GitLabCommitAction("create", this.blobs$2.templateFilePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64");
                return (B1)gitLabCommitAction;
            }

            public final boolean isDefinedAt(boolean x1) {
                boolean bl = x1;
                boolean bl2 = bl ? true : true;
                return bl2;
            }
            {
                this.blobs$2 = blobs$2;
            }
        });
    }

    private Try<List<GitLabCommitAction>> createAttachmentsRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List list2;
            if (blobs.attachments().files().isEmpty()) {
                list2 = List$.MODULE$.empty();
            } else {
                Set set;
                ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).addQueryParam("path", blobs.attachments().folderName()).get(new StringBuilder(26).append("/projects/").append(this.repoName()).append("/repository/tree").toString()).doRequest(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(GitLabTree.class))).get();
                if (HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    set = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])response.getBody()), (Function1 & Serializable)x$9 -> x$9.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
                } else {
                    HttpStatus httpStatus = response.getStatusCode();
                    HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
                    if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                        set = Predef$.MODULE$.Set().empty();
                    } else {
                        throw new TemplateVersioningException("Unable to list repository tree", null, response.getStatusCodeValue());
                    }
                }
                Set existingAttachments = set;
                list2 = (List)((IterableOnceOps)blobs.attachments().files().view().filterNot((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)existingAttachments.contains((Object)file.fileName())))).foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable)(list, file) -> {
                    GitLabCommitAction gitLabCommitAction = new GitLabCommitAction("create", new StringBuilder(1).append(blobs.attachments().folderName()).append("/").append(file.fileName()).toString(), Base64.getEncoder().encodeToString((byte[])file.getContent().apply()), "base64");
                    return list.$colon$colon((Object)gitLabCommitAction);
                });
            }
            return list2;
        });
    }

    private String repoName() {
        return this.urlEncode(this.config.repository());
    }

    private String urlEncode(String value) {
        return UrlEscapers.urlPathSegmentEscaper().escape(value);
    }

    private ScmHttpClientWrapper gitLabRequest() {
        return HttpClientRequest$.MODULE$.newRequest(this.config.restApiUrl()).setUriEncoded(true).withAuth(this.config.credential());
    }

    public static final /* synthetic */ void $anonfun$testRepository$2(Void x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(ResponseEntity x$5) {
        HttpStatus httpStatus = x$5.getStatusCode();
        HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
        return !(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null);
    }

    public GitLabScmConnector(GitLabScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

