/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector.github;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException$;
import com.xebialabs.xlrelease.versioning.scm.connector.Attachments;
import com.xebialabs.xlrelease.versioning.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubOAuth2Token;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubScmCredential;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubUsernamePasswordCredential;
import java.io.Serializable;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\u0007\u000e\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006M\u0001!\ta\n\u0005\tU\u0001A)\u0019!C\u0005W!)Q\b\u0001C)}!)A\t\u0001C)\u000b\")A\r\u0001C)K\")A\u000e\u0001C\u0005[\")!\u0010\u0001C\u0005w\u00161\u0011\u0011\u0001\u0001\u0001\u0003\u0007Aq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u00024\u0001!I!!\u000e\u0003%\u001dKG\u000fS;c'\u000el7i\u001c8oK\u000e$xN\u001d\u0006\u0003\u001d=\taaZ5uQV\u0014'B\u0001\t\u0012\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u0013'\u0005\u00191oY7\u000b\u0005Q)\u0012A\u0003<feNLwN\\5oO*\u0011acF\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001G\r\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u0005y\u0011B\u0001\u0011\u0010\u0005M\u0011Vm\u001d;Ba&\u001c6-\\\"p]:,7\r^8s\u0003\u0019\u0019wN\u001c4jOB\u00111\u0005J\u0007\u0002\u001b%\u0011Q%\u0004\u0002\u0019\u000f&$\b*\u001e2TG6\u001cuN\u001c8fGR|'oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002)SA\u00111\u0005\u0001\u0005\u0006C\t\u0001\rAI\u0001\u0006?J,\u0007o\\\u000b\u0002YA\u0019QF\r\u001b\u000e\u00039R!a\f\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002c\u0005)1oY1mC&\u00111G\f\u0002\u0004)JL\bCA\u001b<\u001b\u00051$B\u0001\b8\u0015\tA\u0014(A\u0004l_\"\u001cXo[3\u000b\u0003i\n1a\u001c:h\u0013\tadG\u0001\u0007H\u0011J+\u0007o\\:ji>\u0014\u00180\u0001\buKN$(+\u001a9pg&$xN]=\u0016\u0003}\u00022!\f\u001aA!\t\t%)D\u00011\u0013\t\u0019\u0005G\u0001\u0003V]&$\u0018\u0001D2p[6LG/\u00118e)\u0006<G\u0003\u0002$S/r\u00032!\f\u001aH!\tAuJ\u0004\u0002J\u001bB\u0011!\nM\u0007\u0002\u0017*\u0011AjG\u0001\u0007yI|w\u000e\u001e \n\u00059\u0003\u0014A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!A\u0014\u0019\t\u000bM+\u0001\u0019\u0001+\u0002\u000b\tdwNY:\u0011\u0005y)\u0016B\u0001,\u0010\u0005\u0015\u0011En\u001c2t\u0011\u0015AV\u00011\u0001Z\u0003)\u0019w.\\7ji&sgm\u001c\t\u0003=iK!aW\b\u0003'Y\u000bG.\u001b3bi\u0016$7i\\7nSRLeNZ8\t\u000bu+\u0001\u0019\u00010\u0002\tU\u001cXM\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003CV\ta\u0001Z8nC&t\u0017BA2a\u0005-)6/\u001a:Qe>4\u0017\u000e\\3\u0002\u001bQ\fwMT8u!J,7/\u001a8u)\t1'\u000eE\u0002.e\u001d\u0004\"!\u00115\n\u0005%\u0004$a\u0002\"p_2,\u0017M\u001c\u0005\u0006W\u001a\u0001\raR\u0001\u0004i\u0006<\u0017a\t4jYR,'oT;u\u00032\u0014X-\u00193z+Bdw.\u00193fI\u0006#H/Y2i[\u0016tGo\u001d\u000b\u0005]F\u001c\b\u0010\u0005\u0002\u001f_&\u0011\u0001o\u0004\u0002\f\u0003R$\u0018m\u00195nK:$8\u000fC\u0003s\u000f\u0001\u0007A'\u0001\u0003sKB|\u0007\"\u0002;\b\u0001\u0004)\u0018\u0001\u00032bg\u0016$&/Z3\u0011\u0005U2\u0018BA<7\u0005\u00199\u0005\n\u0016:fK\")\u0011p\u0002a\u0001]\u0006Y\u0011\r\u001e;bG\"lWM\u001c;t\u0003)!(/_\"p]:,7\r\u001e\u000b\u0002yB\u0019QFM?\u0011\u0005Ur\u0018BA@7\u0005\u00199\u0015\u000e\u001e%vE\nYa*Y7fI\u001eC%\t\\8c!\u0019\t\u0015QA$\u0002\n%\u0019\u0011q\u0001\u0019\u0003\rQ+\b\u000f\\33!\r)\u00141B\u0005\u0004\u0003\u001b1$AB$I\u00052|'-A\u0006va2|\u0017\r\u001a\"m_\n\u001cH\u0003CA\n\u0003W\ty#!\r\u0011\t5\u0012\u0014Q\u0003\t\u0007\u0003/\t\t#a\n\u000f\t\u0005e\u0011Q\u0004\b\u0004\u0015\u0006m\u0011\"A\u0019\n\u0007\u0005}\u0001'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\u0005\u0019&\u001cHOC\u0002\u0002 A\u00022!!\u000b\n\u001b\u0005\u0001\u0001BBA\u0017\u0015\u0001\u0007q)\u0001\u0005gS2,\u0007/\u0019;i\u0011\u0015\u0019&\u00021\u0001U\u0011\u0015\u0011(\u00021\u00015\u0003)\u0019'/Z1uKR\u0013X-\u001a\u000b\t\u0003o\tI$a\u000f\u0002@A\u0019QFM;\t\u000bI\\\u0001\u0019\u0001\u001b\t\r\u0005u2\u00021\u0001H\u0003-\u0011\u0017m]3Ue\u0016,7\u000b[1\t\rM[\u0001\u0019AA!!\u0019\t9\"a\u0011\u0002(%!\u0011QIA\u0013\u0005!IE/\u001a:bE2,\u0007")
public class GitHubScmConnector
extends RestApiScmConnector {
    private Try<GHRepository> _repo;
    private final GitHubScmConnectorConfig config;
    private volatile boolean bitmap$0;

    private Try<GHRepository> _repo$lzycompute() {
        GitHubScmConnector gitHubScmConnector = this;
        synchronized (gitHubScmConnector) {
            if (!this.bitmap$0) {
                Try repo = this.tryConnect().map((Function1 & Serializable)gh -> gh.getRepository($this.config.repository()));
                this._repo = repo.recoverWith((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        HttpException httpException;
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof GHFileNotFoundException) {
                            GHFileNotFoundException gHFileNotFoundException = (GHFileNotFoundException)A1;
                            object = new Failure((Throwable)((Object)new TemplateVersioningException("Repository not found", (Throwable)gHFileNotFoundException, 404)));
                        } else if (A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 401) {
                            object = new Failure((Throwable)((Object)new TemplateVersioningException("Invalid credentials", (Throwable)httpException, 401)));
                        } else if (A1 instanceof Exception) {
                            Exception exception = (Exception)A1;
                            object = new Failure((Throwable)((Object)new TemplateVersioningException(exception.getMessage(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3())));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        HttpException httpException;
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof GHFileNotFoundException ? true : (throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 401 ? true : throwable instanceof Exception);
                        return bl;
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this._repo;
    }

    private Try<GHRepository> _repo() {
        return !this.bitmap$0 ? this._repo$lzycompute() : this._repo;
    }

    @Override
    public Try<BoxedUnit> testRepository() {
        return this._repo().map((Function1 & Serializable)x$1 -> {
            GitHubScmConnector.$anonfun$testRepository$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this._repo().flatMap((Function1 & Serializable)repo -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getRef(new StringBuilder(6).append("heads/").append($this.config.branch()).toString())).recoverWith((PartialFunction)new Serializable(this, (GHRepository)repo){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ GitHubScmConnector $outer;
            private final GHRepository repo$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HttpException httpException;
                A1 A1 = x1;
                Object object = A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? this.$outer.com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(this.repo$2) : (A1 instanceof GHFileNotFoundException ? this.$outer.com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(this.repo$2) : function1.apply(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                HttpException httpException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? true : throwable instanceof GHFileNotFoundException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.repo$2 = repo$2;
            }
        }).flatMap((Function1 & Serializable)headRef -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getTree($this.config.branch())).map((Function1 & Serializable)baseTree -> {
            Blobs newBlobs = new Blobs(blobs.templateId(), blobs.dsl(), this.filterOutAlreadyUploadedAttachments((GHRepository)repo, (GHTree)baseTree, blobs.attachments()));
            return new Tuple2(baseTree, (Object)newBlobs);
        }).flatMap((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GHTree baseTree = (GHTree)tuple2._1();
            Blobs newBlobs = (Blobs)tuple2._2();
            Try try_ = this.uploadBlobs(blobs.templateFilePath(), newBlobs, (GHRepository)repo).flatMap((Function1 & Serializable)ghNamedBlobs -> this.createTree((GHRepository)repo, baseTree.getSha(), (Iterable<Tuple2<String, GHBlob>>)ghNamedBlobs).flatMap((Function1 & Serializable)newTree -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.createCommit().message(commitInfo.message()).tree(newTree.getSha()).parent(headRef.getObject().getSha()).create()).flatMap((Function1 & Serializable)commit -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.createRef(commitInfo.tag().toString(), commit.getSHA1())).flatMap((Function1 & Serializable)x$3 -> {
                GHRef gHRef = x$3;
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> headRef.updateTo(commit.getSHA1())).map((Function1 & Serializable)x$2 -> {
                    BoxedUnit boxedUnit = x$2;
                    String string = commit.getSHA1();
                    return string;
                });
                return try_;
            }))));
            return try_;
        })));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this._repo().map((Function1 & Serializable)repo -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$tagNotPresent$1(tag, repo)));
    }

    private Attachments filterOutAlreadyUploadedAttachments(GHRepository repo, GHTree baseTree, Attachments attachments) {
        Seq toUpload = attachments.files().isEmpty() ? (Seq)package$.MODULE$.Seq().empty() : (Seq)Option$.MODULE$.apply((Object)baseTree.getEntry("XLRelease")).flatMap((Function1 & Serializable)rootTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable)() -> rootTreeEntry.asTree()).toOption().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$3(x$5))).flatMap((Function1 & Serializable)rootTree -> Option$.MODULE$.apply((Object)rootTree.getEntry(".attachments")).flatMap((Function1 & Serializable)attachmentTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable)() -> attachmentTreeEntry.asTree()).toOption().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$7(x$6))).map((Function1 & Serializable)attachmentTree -> {
            BoxedUnit boxedUnit;
            Map filesMap = (Map)Map$.MODULE$.apply((Seq)attachments.files().map((Function1 & Serializable)file -> new Tuple2((Object)file.fileName(), file)));
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(attachmentTree.getTree()).asScala().view().takeWhile((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)filesMap.nonEmpty()))).foreach((Function1 & Serializable)entry -> (Map)filesMap.$minus$eq((Object)entry.getPath()));
            if (filesMap.nonEmpty() && attachmentTree.isTruncated()) {
                scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)filesMap.flatMap((Function1 & Serializable)filename -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getFileContent(new StringBuilder(1).append(attachments.folderName()).append("/").append(filename).toString(), $this.config.branch())).toOption().map((Function1 & Serializable)x$8 -> x$8.getName()));
                boxedUnit = filesMap.$minus$minus$eq((IterableOnce)toRemove);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return filesMap.values().toSeq();
        })))).getOrElse((Function0 & Serializable)() -> attachments.files());
        return new Attachments(attachments.folderName(), (Seq<BinaryFile>)toUpload);
    }

    private Try<GitHub> tryConnect() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GitHubBuilder gitHubBuilder;
            GitHubBuilder builder = new GitHubBuilder().withRateLimitHandler(RateLimitHandler.FAIL).withAbuseLimitHandler(AbuseLimitHandler.FAIL).withEndpoint($this.config.restApiUrl());
            GitHubScmCredential gitHubScmCredential = $this.config.credential();
            if (gitHubScmCredential instanceof GitHubUsernamePasswordCredential) {
                GitHubUsernamePasswordCredential gitHubUsernamePasswordCredential = (GitHubUsernamePasswordCredential)gitHubScmCredential;
                gitHubBuilder = builder.withPassword(gitHubUsernamePasswordCredential.username(), PasswordEncrypter.getInstance().ensureDecrypted(gitHubUsernamePasswordCredential.password()));
            } else if (gitHubScmCredential instanceof GitHubOAuth2Token) {
                GitHubOAuth2Token gitHubOAuth2Token = (GitHubOAuth2Token)gitHubScmCredential;
                gitHubBuilder = builder.withOAuthToken(PasswordEncrypter.getInstance().ensureDecrypted(gitHubOAuth2Token.token()));
            } else {
                if (gitHubScmCredential == null) {
                    throw new IllegalStateException(new StringBuilder(48).append("No credential provided for GitHub SCM config '").append($this.config.getTitle()).append("'.").toString());
                }
                throw new MatchError((Object)gitHubScmCredential);
            }
            return builder.build();
        });
    }

    private Try<List<Tuple2<String, GHBlob>>> uploadBlobs(String filepath, Blobs blobs, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ListBuffer ghBlobs = ListBuffer$.MODULE$.empty();
            ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filepath), (Object)repo.createBlob().binaryContent((byte[])blobs.dsl().getContent().apply()).create()));
            blobs.attachments().files().foreach((Function1 & Serializable)attachment -> (ListBuffer)ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(blobs.attachments().folderName()).append("/").append(attachment.fileName()).toString()), (Object)repo.createBlob().binaryContent((byte[])attachment.getContent().apply()).create())));
            return ghBlobs.toList();
        });
    }

    private Try<GHTree> createTree(GHRepository repo, String baseTreeSha, Iterable<Tuple2<String, GHBlob>> blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GHTreeBuilder builder = repo.createTree().baseTree(baseTreeSha);
            blobs.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String filename = (String)tuple2._1();
                GHBlob ghBlob = (GHBlob)tuple2._2();
                GHTreeBuilder gHTreeBuilder = builder.shaEntry(filename, ghBlob.getSha(), false);
                return gHTreeBuilder;
            });
            return builder.create();
        });
    }

    public static final /* synthetic */ void $anonfun$testRepository$1(GHRepository x$1) {
    }

    public final Try com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GHRef defaultBranch = repo.getRef(new StringBuilder(6).append("heads/").append(repo.getDefaultBranch()).toString());
            return repo.createRef(new StringBuilder(11).append("refs/heads/").append($this.config.branch()).toString(), defaultBranch.getObject().getSha());
        });
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(String tag$1, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getRef(new StringBuilder(5).append("tags/").append(tag$1).toString())).failed().isSuccess();
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$3(GHTree x$5) {
        return x$5 != null;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$7(GHTree x$6) {
        return x$6 != null;
    }

    public GitHubScmConnector(GitHubScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

