/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm;

import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateToBlobsConverter;
import com.xebialabs.xlrelease.versioning.scm.connector.BaseScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0005\u00194A\u0001C\u0005\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!!\u0003A!A!\u0002\u0013)\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011=\u0002!\u0011!Q\u0001\nABQa\r\u0001\u0005\u0002QBQA\u0013\u0001\u0005\u0002-\u0013\u0011dU2n)\u0016l\u0007\u000f\\1uKN#xN]1hKN+'O^5dK*\u0011!bC\u0001\u0004g\u000el'B\u0001\u0007\u000e\u0003)1XM]:j_:Lgn\u001a\u0006\u0003\u001d=\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\t\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0012aA2p[\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u0006\u00192oY7D_:tWm\u0019;peN+'O^5dKB\u0011QDH\u0007\u0002\u0013%\u0011q$\u0003\u0002\u0014'\u000el7i\u001c8oK\u000e$xN]*feZL7-Z\u0001\u001cg\u000elG+Z7qY\u0006$X\rV8CY>\u00147oQ8om\u0016\u0014H/\u001a:\u0011\u0005u\u0011\u0013BA\u0012\n\u0005m\u00196-\u001c+f[Bd\u0017\r^3U_\ncwNY:D_:4XM\u001d;fe\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u000e\u0003\u001d\u0019XM\u001d<jG\u0016L!AK\u0014\u0003\u001dI+G.Z1tKN+'O^5dK\u0006\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\t1S&\u0003\u0002/O\t\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0003q\u0019wN\u001c4jOV\u0014\u0018\r^5p]Z\u000b'/[1cY\u0016\u001cVM\u001d<jG\u0016\u0004\"AJ\u0019\n\u0005I:#\u0001H\"p]\u001aLw-\u001e:bi&|gNV1sS\u0006\u0014G.Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\rU2t\u0007O\u001d;!\ti\u0002\u0001C\u0003\u001c\r\u0001\u0007A\u0004C\u0003!\r\u0001\u0007\u0011\u0005C\u0003%\r\u0001\u0007Q\u0005C\u0003,\r\u0001\u0007A\u0006C\u00030\r\u0001\u0007\u0001\u0007\u000b\u0002\u0007yA\u0011Q\bS\u0007\u0002})\u0011q\bQ\u0001\u000bC:tw\u000e^1uS>t'BA!C\u0003\u001d1\u0017m\u0019;pefT!a\u0011#\u0002\u000b\t,\u0017M\\:\u000b\u0005\u00153\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tIeHA\u0005BkR|w/\u001b:fI\u0006\u00012M]3bi\u0016tUm\u001e,feNLwN\u001c\u000b\u0006\u0019^K6,\u0018\t\u0003\u001bRs!A\u0014*\u0011\u0005=;R\"\u0001)\u000b\u0005E\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002T/\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019v\u0003C\u0003Y\u000f\u0001\u0007A*\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012DQAW\u0004A\u00021\u000bqA^3sg&|g\u000eC\u0003]\u000f\u0001\u0007A*A\u0006eKN\u001c'/\u001b9uS>t\u0007\"\u00020\b\u0001\u0004a\u0015\u0001B;tKJD#\u0001\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r$\u0015AC:uKJ,w\u000e^=qK&\u0011QM\u0019\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class ScmTemplateStorageService {
    private final ScmConnectorService scmConnectorService;
    private final ScmTemplateToBlobsConverter scmTemplateToBlobsConverter;
    private final ReleaseService releaseService;
    private final UserProfileService userProfileService;
    private final ConfigurationVariableService configurationVariableService;

    public String createNewVersion(String templateId, String version, String description, String user) {
        Release template = this.releaseService.findById(templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(template.getId());
        ScmConnectorConfig scmConnectorConfig = scmConfiguration;
        if (scmConnectorConfig instanceof BaseScmConnectorConfig) {
            BaseScmConnectorConfig baseScmConnectorConfig = (BaseScmConnectorConfig)scmConnectorConfig;
            this.configurationVariableService.resolve((Configuration)baseScmConnectorConfig);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ScmConnector scmConnector = scmConfiguration.getConnector();
        Blobs blobs = this.scmTemplateToBlobsConverter.convertTemplate(template);
        String identifier = scmConnector.getIdentifier(blobs);
        ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, identifier).get();
        UserProfile userProfile = this.userProfileService.findByUsername(user);
        scmConnector.createNewVersion(blobs, commitInfo, userProfile).get();
        return commitInfo.tag().refName();
    }

    @Autowired
    public ScmTemplateStorageService(ScmConnectorService scmConnectorService, ScmTemplateToBlobsConverter scmTemplateToBlobsConverter, ReleaseService releaseService, UserProfileService userProfileService, ConfigurationVariableService configurationVariableService) {
        this.scmConnectorService = scmConnectorService;
        this.scmTemplateToBlobsConverter = scmTemplateToBlobsConverter;
        this.releaseService = releaseService;
        this.userProfileService = userProfileService;
        this.configurationVariableService = configurationVariableService;
    }
}

