package com.xebialabs.xlrelease.versioning.templates.actors.extensions

import akka.actor.Actor.Receive
import akka.actor.{Actor, ActorRef}
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages.ExtensionCommand
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages.{NewTemplateVersion, RestoreRevision}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

object TemplateVersionExtensionActorMessages {

  case class NewTemplateVersion(name: String, description: String, author: String) extends ExtensionCommand

  case class RestoreRevision(revisionId: Int) extends ExtensionCommand

}

@Component
class TemplateVersionActorExtensionHandlerFactory @Autowired()(templateStorageService: TemplateStorageService,
                                                               implicit val xlrConfig: XlrConfig)
  extends ActorExtensionHandlerFactory
    with Logging {

  override def supports(clazz: Class[_ <: Actor]): Boolean = classOf[ReleaseExecutionActor].isAssignableFrom(clazz)

  override def getHandler(self: ActorRef, sender: () => ActorRef, release: => Release): Receive = {
    case NewTemplateVersion(name, description, author) => replyOrFail(sender) {
      templateStorageService.saveVersion(release.getId, author, name, description)
    }
    case RestoreRevision(revisionId) => replyOrFail(sender) {
      templateStorageService.restore(release.getId, revisionId)
    }
  }

}
