package com.xebialabs.xlrelease.versioning.templates

import com.xebialabs.deployit.plumbing.serialization.ResolutionContext
import com.xebialabs.xlrelease.domain.Release

import scala.util.Try

trait TemplateStorageService {

  def saveRevision(template: Release, user: String, message: String): Unit

  def saveVersion(templateId: String, user: String, versionName: String, message: String): Try[Int]

  def load(revisionId: Int, context: ResolutionContext): Release

  def restore(templateId: String, revisionId: Int): Release

  def deleteRevision(templateId: String, revisionId: Int): Unit

  def deleteRevisions(templateId: String, revisionIds: Seq[Int]): Unit
}
