package com.xebialabs.xlrelease.versioning.templates.configuration

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor
import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, Type}
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class TemplateVersioningInitializer @Autowired()(configurationRepository: ConfigurationRepository)
  extends BaseInitializingUpgrade with Logging with ClassNameToString {

  override def doUpgrade(): Boolean = {
    logger.debug("Creating default template versioning settings")
    val descriptor: Descriptor = getDescriptor(Type.valueOf(classOf[TemplateVersioningSettings]))
    val ci: TemplateVersioningSettings = descriptor.newInstance(TemplateVersioningSettings.TEMPLATE_VERSIONING_ID)
    if (!configurationRepository.exists(ci.getId)) {
      configurationRepository.create(ci)
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "7.6.0")

}
