package com.xebialabs.xlrelease.versioning.templates

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.activity.{ActivityLogger, LoggingParams}
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.domain.{Release, ReleaseActivity}
import com.xebialabs.xlrelease.events.{Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.versioning.templates.domain.events.{RevisionDeletedEvent, TemplateVersioningEvent, VersionCreatedEvent}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class TemplateVersioningActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
  extends ActivityLogger[TemplateVersioningEvent] {

  @Subscribe
  def onEvent(event: TemplateVersioningEvent): Unit = log(event)

  override def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@RevisionDeletedEvent(templateId, revisionId) =>
      LoggingParams(
        Some(templateId),
        Some(ev.username),
        ReleaseActivity.CUSTOM.create(ev.timestamp, ev.username, Type.valueOf(classOf[Release]), templateId, s"Template revision '$revisionId' deleted")
      )
    case ev@VersionCreatedEvent(templateId, version) =>
      LoggingParams(
        Some(templateId),
        Some(ev.username),
        ReleaseActivity.CUSTOM.create(ev.timestamp, ev.username, Type.valueOf(classOf[Release]), templateId, s"Template version '$version' created")
      )
  }
}
