/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector.gitlab;

import com.google.common.net.UrlEscapers;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.scm.connector.BasicScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.HttpClientRequest$;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmHttpClientWrapper;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommit;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommitAction;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommitResponse;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabProjectResponse;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabTree;
import java.io.Serializable;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001E\u0011!cR5u\u0019\u0006\u00147kY7D_:tWm\u0019;pe*\u00111\u0001B\u0001\u0007O&$H.\u00192\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0002tG6T!!\u0003\u0006\u0002\u0015Y,'o]5p]&twM\u0003\u0002\f\u0019\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001b9\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003=\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!!\u0005\"bg&\u001c7kY7D_:tWm\u0019;pe\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004d_:4\u0017n\u001a\t\u00033ii\u0011AA\u0005\u00037\t\u0011\u0001dR5u\u0019\u0006\u00147kY7D_:tWm\u0019;pe\u000e{gNZ5h\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q\u0004\t\t\u00033\u0001AQa\u0006\u000fA\u0002aAQA\t\u0001\u0005R\r\na\u0002^3tiJ+\u0007o\\:ji>\u0014\u00180F\u0001%!\r)#\u0006L\u0007\u0002M)\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tYcEA\u0002Uef\u0004\"!\f\u0018\u000e\u0003!J!a\f\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\u0001!\tFM\u0001\rG>lW.\u001b;B]\u0012$\u0016m\u001a\u000b\u0005g}\"\u0015\nE\u0002&UQ\u0002\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c)\u001b\u0005A$BA\u001d\u0011\u0003\u0019a$o\\8u}%\u00111\bK\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<Q!)\u0001\t\ra\u0001\u0003\u0006)!\r\\8cgB\u00111CQ\u0005\u0003\u0007\u0012\u0011QA\u00117pENDQ!\u0012\u0019A\u0002\u0019\u000b!bY8n[&$\u0018J\u001c4p!\t\u0019r)\u0003\u0002I\t\t\u0019b+\u00197jI\u0006$X\rZ\"p[6LG/\u00138g_\")!\n\ra\u0001i\u0005!Qo]3s\u0011\u0015a\u0005\u0001\"\u0015N\u00035!\u0018m\u001a(piB\u0013Xm]3oiR\u0011aJ\u0015\t\u0004K)z\u0005CA\u0017Q\u0013\t\t\u0006FA\u0004C_>dW-\u00198\t\u000bM[\u0005\u0019\u0001\u001b\u0002\u0007Q\fw\rC\u0003V\u0001\u0011\u0005a+\u0001\u0007de\u0016\fG/\u001a\"sC:\u001c\u0007\u000eF\u0001%\u0011\u0015A\u0006\u0001\"\u0003Z\u00031\u0019'/Z1uK\u000e{W.\\5u)\tQf\fE\u0002&Um\u0003\"!\u0007/\n\u0005u\u0013!\u0001F$ji2\u000b'mQ8n[&$(+Z:q_:\u001cX\rC\u0003`/\u0002\u0007\u0001-A\u0006sKF,Xm\u001d;C_\u0012L\bCA\rb\u0013\t\u0011'A\u0001\u0007HSRd\u0015MY\"p[6LG\u000fC\u0003e\u0001\u0011%Q-A\u0005de\u0016\fG/\u001a+bOR\u0019a-_>\u0011\u0007\u0015Rs\rE\u0002i_Fl\u0011!\u001b\u0006\u0003U.\fA\u0001\u001b;ua*\u0011A.\\\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta.A\u0002pe\u001eL!\u0001]5\u0003\u001dI+7\u000f]8og\u0016,e\u000e^5usB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(\u0001\u0002,pS\u0012DQA_2A\u0002Q\nq\u0001^1h\u001d\u0006lW\rC\u0003}G\u0002\u0007A'A\u0002tQ\u0006DQA \u0001\u0005\n}\fac\u0019:fCR,Gi\u001d7SKF,Xm\u001d;BGRLwN\u001c\u000b\u0005\u0003\u0003\tI\u0001\u0005\u0003&U\u0005\r\u0001cA\r\u0002\u0006%\u0019\u0011q\u0001\u0002\u0003%\u001dKG\u000fT1c\u0007>lW.\u001b;BGRLwN\u001c\u0005\u0006\u0001v\u0004\r!\u0011\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0003y\u0019'/Z1uK\u0006#H/Y2i[\u0016tGo\u001d*fcV,7\u000f^!di&|g\u000e\u0006\u0003\u0002\u0012\u0005\u0015\u0002\u0003B\u0013+\u0003'\u0001b!!\u0006\u0002 \u0005\ra\u0002BA\f\u00037q1aNA\r\u0013\u0005I\u0013bAA\u000fQ\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0011\u0003G\u0011A\u0001T5ti*\u0019\u0011Q\u0004\u0015\t\r\u0001\u000bY\u00011\u0001B\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t\u0001B]3q_:\u000bW.Z\u000b\u0002i!9\u0011q\u0006\u0001\u0005\n\u0005E\u0012!C;sY\u0016s7m\u001c3f)\r!\u00141\u0007\u0005\b\u0003k\ti\u00031\u00015\u0003\u00151\u0018\r\\;f\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\tQbZ5u\u0019\u0006\u0014'+Z9vKN$XCAA\u001f!\r\u0019\u0012qH\u0005\u0004\u0003\u0003\"!\u0001F*d[\"#H\u000f]\"mS\u0016tGo\u0016:baB,'\u000f")
public class GitLabScmConnector
extends BasicScmConnector {
    private final GitLabScmConnectorConfig config;

    @Override
    public Try<BoxedUnit> testRepository() {
        return this.gitLabRequest().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName()}))).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$1).tried()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            GitLabScmConnector.$anonfun$testRepository$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, String user) {
        return this.createBranch().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.createDslRequestAction(blobs).flatMap((Function1 & Serializable & scala.Serializable)dslCommitAction -> this.createAttachmentsRequestAction(blobs).flatMap((Function1 & Serializable & scala.Serializable)attachmentCommitAction -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GitLabCommitAction gitLabCommitAction = dslCommitAction;
            return new GitLabCommit($this.config.branch(), commitInfo.message(), JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)attachmentCommitAction.$colon$colon((Object)gitLabCommitAction)).asJavaCollection());
        }).flatMap((Function1 & Serializable & scala.Serializable)requestBody -> this.createCommit((GitLabCommit)requestBody).flatMap((Function1 & Serializable & scala.Serializable)gitCommitInfo -> this.createTag(commitInfo.tag().refName(), gitCommitInfo.id()).map((Function1 & Serializable & scala.Serializable)_ -> gitCommitInfo.id()))))));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this.gitLabRequest().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/tags/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName(), tag}))).doRequest(ClassTag$.MODULE$.apply(Void.class)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GitLabScmConnector.$anonfun$tagNotPresent$1(x$4)));
    }

    public Try<BoxedUnit> createBranch() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ResponseEntity projectResponse = (ResponseEntity)this.gitLabRequest().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName()}))).doRequest(ClassTag$.MODULE$.apply(GitLabProjectResponse.class)).get();
            if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(projectResponse).isSuccessful()) {
                throw new TemplateVersioningException("Unable to retrieve default branch", null, projectResponse.getStatusCodeValue());
            }
            boolean exist = HttpClientRequest$.MODULE$.ResponseEntityExtension((ResponseEntity)this.gitLabRequest().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/branches/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName(), $this.config.branch()}))).doRequest(ClassTag$.MODULE$.apply(Void.class)).get()).isSuccessful();
            if (!exist) {
                ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("ref", ((GitLabProjectResponse)projectResponse.getBody()).default_branch()).addQueryParam("branch", $this.config.branch());
                String x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/branches"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName()}));
                Null$ x$11 = qual$1.post$default$2();
                ResponseEntity response = (ResponseEntity)qual$1.post(x$10, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
                if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    throw new TemplateVersioningException("Unable to create branch", null, response.getStatusCodeValue());
                }
            }
        });
    }

    private Try<GitLabCommitResponse> createCommit(GitLabCommit requestBody) {
        return this.gitLabRequest().post(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/commits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName()})), requestBody).doRequest(ClassTag$.MODULE$.apply(GitLabCommitResponse.class)).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$5).checkResponse("Error occured while trying to commit on GitLab")).map((Function1 & Serializable & scala.Serializable)x$6 -> (GitLabCommitResponse)x$6.getBody());
    }

    private Try<ResponseEntity<Void>> createTag(String tagName, String sha) {
        ScmHttpClientWrapper qual$2 = this.gitLabRequest().addQueryParam("tag_name", tagName).addQueryParam("ref", sha);
        String x$12 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/tags"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName()}));
        Null$ x$13 = qual$2.post$default$2();
        return qual$2.post(x$12, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$7).checkResponse("Error occurred while trying to create tag"));
    }

    private Try<GitLabCommitAction> createDslRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/files/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName(), this.urlEncode(blobs.filePath())}))).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
            HttpStatus httpStatus = response.getStatusCode();
            HttpStatus httpStatus2 = HttpStatus.UNAUTHORIZED;
            if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                throw new TemplateVersioningException("Unable to connect to the repository.", null, response.getStatusCodeValue());
            }
            return HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful();
        }).collect((PartialFunction)new scala.Serializable(null, blobs){
            public static final long serialVersionUID = 0L;
            private final Blobs blobs$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                GitLabCommitAction gitLabCommitAction = true == A1 ? new GitLabCommitAction("update", this.blobs$2.filePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64") : new GitLabCommitAction("create", this.blobs$2.filePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64");
                return (B1)gitLabCommitAction;
            }

            public final boolean isDefinedAt(boolean x1) {
                boolean bl = x1;
                boolean bl2 = bl ? true : true;
                return bl2;
            }
            {
                this.blobs$2 = blobs$2;
            }
        });
    }

    private Try<List<GitLabCommitAction>> createAttachmentsRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            List list2;
            if (blobs.attachments().files().isEmpty()) {
                list2 = List$.MODULE$.empty();
            } else {
                Set set;
                ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).addQueryParam("path", blobs.attachments().folderName()).get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/projects/", "/repository/tree"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repoName()}))).doRequest(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(GitLabTree.class))).get();
                if (HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])response.getBody())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                } else {
                    HttpStatus httpStatus = response.getStatusCode();
                    HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
                    if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                        set = Predef$.MODULE$.Set().empty();
                    } else {
                        throw new TemplateVersioningException("Unable to list repository tree", null, response.getStatusCodeValue());
                    }
                }
                Set existingAttachments = set;
                list2 = (List)blobs.attachments().files().view().filterNot((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)existingAttachments.contains((Object)file.fileName()))).foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(list, file) -> {
                    GitLabCommitAction gitLabCommitAction = new GitLabCommitAction("create", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blobs.attachments().folderName(), file.fileName()})), Base64.getEncoder().encodeToString((byte[])file.getContent().apply()), "base64");
                    return list.$colon$colon((Object)gitLabCommitAction);
                });
            }
            return list2;
        });
    }

    private String repoName() {
        return this.urlEncode(this.config.repository());
    }

    private String urlEncode(String value) {
        return UrlEscapers.urlPathSegmentEscaper().escape(value);
    }

    private ScmHttpClientWrapper gitLabRequest() {
        return HttpClientRequest$.MODULE$.newRequest(this.config.restApiUrl()).setUriEncoded(true).withAuth(this.config.credential());
    }

    public static final /* synthetic */ void $anonfun$testRepository$2(Void x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(ResponseEntity x$4) {
        HttpStatus httpStatus = x$4.getStatusCode();
        HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
        return !(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null);
    }

    public GitLabScmConnector(GitLabScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

