/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateToBlobsConverter;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001b\tI2kY7UK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0002tG6T!!\u0002\u0004\u0002\u0015Y,'o]5p]&twM\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012aE:d[\u000e{gN\\3di>\u00148+\u001a:wS\u000e,\u0007CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005M\u00196-\\\"p]:,7\r^8s'\u0016\u0014h/[2f\u0011!Y\u0002A!A!\u0002\u0013a\u0012aG:d[R+W\u000e\u001d7bi\u0016$vN\u00117pEN\u001cuN\u001c<feR,'\u000f\u0005\u0002\u0018;%\u0011aD\u0001\u0002\u001c'\u000elG+Z7qY\u0006$X\rV8CY>\u00147oQ8om\u0016\u0014H/\u001a:\t\u0011\u0001\u0002!\u0011!Q\u0001\n\u0005\naB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0002#K5\t1E\u0003\u0002%\r\u000591/\u001a:wS\u000e,\u0017B\u0001\u0014$\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016DQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtD\u0003\u0002\u0016,Y5\u0002\"a\u0006\u0001\t\u000bU9\u0003\u0019\u0001\f\t\u000bm9\u0003\u0019\u0001\u000f\t\u000b\u0001:\u0003\u0019A\u0011)\u0005\u001dz\u0003C\u0001\u0019<\u001b\u0005\t$B\u0001\u001a4\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003iU\nqAZ1di>\u0014\u0018P\u0003\u00027o\u0005)!-Z1og*\u0011\u0001(O\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!(A\u0002pe\u001eL!\u0001P\u0019\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002 \u0001\t\u0003y\u0014\u0001E2sK\u0006$XMT3x-\u0016\u00148/[8o)\u0015\u00015*T(R!\t\t\u0005J\u0004\u0002C\rB\u00111\tE\u0007\u0002\t*\u0011Q\tD\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!a\u0012\t\t\u000b1k\u0004\u0019\u0001!\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0003O{\u0001\u0007\u0001)A\u0004wKJ\u001c\u0018n\u001c8\t\u000bAk\u0004\u0019\u0001!\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u0006%v\u0002\r\u0001Q\u0001\u0005kN,'\u000f\u000b\u0002\u0001)B\u0011Q\u000bW\u0007\u0002-*\u0011qkN\u0001\u000bgR,'/Z8usB,\u0017BA-W\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ScmTemplateStorageService {
    private final ScmConnectorService scmConnectorService;
    private final ScmTemplateToBlobsConverter scmTemplateToBlobsConverter;
    private final ReleaseService releaseService;

    public String createNewVersion(String templateId, String version, String description, String user) {
        Release template = this.releaseService.findById(templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(template.getId());
        ScmConnector scmConnector = scmConfiguration.getConnector();
        Blobs blobs = this.scmTemplateToBlobsConverter.convertTemplate(template);
        String identifier = scmConnector.getIdentifier(blobs);
        ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, identifier).get();
        scmConnector.createNewVersion(blobs, commitInfo, user).get();
        return commitInfo.tag().refName();
    }

    @Autowired
    public ScmTemplateStorageService(ScmConnectorService scmConnectorService, ScmTemplateToBlobsConverter scmTemplateToBlobsConverter, ReleaseService releaseService) {
        this.scmConnectorService = scmConnectorService;
        this.scmTemplateToBlobsConverter = scmTemplateToBlobsConverter;
        this.releaseService = releaseService;
    }
}

