/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse$;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings$;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.versioning.templates.views.VersionView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\tMf\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\ti\u000f\u0001C\u0001\u0003_DqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0004\u0003,\u0001!\tA!\f\t\u000f\t\r\u0004\u0001\"\u0001\u0003f!9!Q\u000f\u0001\u0005\n\t]$A\u0007+f[Bd\u0017\r^3WKJ\u001c\u0018n\u001c8j]\u001e\u0014Vm]8ve\u000e,'B\u0001\f\u0018\u0003%!X-\u001c9mCR,7O\u0003\u0002\u00193\u0005Qa/\u001a:tS>t\u0017N\\4\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgnZ\u0001\fINdW\t\u001f9peR,'\u000f\u0005\u00022m5\t!G\u0003\u00024i\u000591/\u001a:wS\u000e,'BA\u001b\u001a\u0003\r!7\u000f\\\u0005\u0003oI\u00121\u0002R:m\u000bb\u0004xN\u001d;fe\u0006QB/Z7qY\u0006$XMU3wSNLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011!(P\u0007\u0002w)\u0011A(F\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001 <\u0005i!V-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z\u0003Y!X-\u001c9mCR,7\u000b^8sC\u001e,7+\u001a:wS\u000e,\u0007CA!C\u001b\u0005)\u0012BA\"\u0016\u0005Y!V-\u001c9mCR,7\u000b^8sC\u001e,7+\u001a:wS\u000e,\u0017a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007C\u0001$J\u001b\u00059%B\u0001%\u001a\u0003\u0019\t7\r^8sg&\u0011!j\u0012\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0012a\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\bCA'Q\u001b\u0005q%BA(\u001a\u0003!\u0019XmY;sSRL\u0018BA)O\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f!\t!f+D\u0001V\u0015\t\u0019\u0014$\u0003\u0002X+\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\tQF,D\u0001\\\u0015\ta\u0014$\u0003\u0002^7\n92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\u0018i\u0016l\u0007\u000f\\1uKN#xN]1hK2K7\u000f^3oKJ\u0004\"\u0001Y2\u000e\u0003\u0005T!AY\f\u0002\u0007M\u001cW.\u0003\u0002eC\nI2kY7UK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}QIq\r[5kW2lgn\u001c\t\u0003\u0003\u0002AQaL\u0005A\u0002ABQ\u0001O\u0005A\u0002eBQaP\u0005A\u0002\u0001CQ\u0001R\u0005A\u0002\u0015CQaS\u0005A\u00021CQAU\u0005A\u0002MCQ\u0001W\u0005A\u0002eCQAX\u0005A\u0002}C#!C9\u0011\u0005IlX\"A:\u000b\u0005Q,\u0018AC1o]>$\u0018\r^5p]*\u0011ao^\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA\u00180A\u0003cK\u0006t7O\u0003\u0002{w\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001}\u0003\ry'oZ\u0005\u0003}N\u0014\u0011\"Q;u_^L'/\u001a3\u0002=\u001d,G\u000fV3na2\fG/\u001a,feNLwN\\8j]\u001e\u001cV\r\u001e;j]\u001e\u001cXCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\ta\u0001Z8nC&t'bAA\u0007+\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u0005\u0002\b\tQB+Z7qY\u0006$XMV3sg&|g.\u001b8h'\u0016$H/\u001b8hg\":!\"!\u0006\u0002*\u0005-\u0002\u0003BA\f\u0003Ki!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0003eNTA!a\b\u0002\"\u0005\u0011qo\u001d\u0006\u0003\u0003G\tQA[1wCbLA!a\n\u0002\u001a\t!\u0001+\u0019;i\u0003\u00151\u0018\r\\;fC\t\ti#A\u00050g\u0016$H/\u001b8hg\"\u001a!\"!\r\u0011\t\u0005]\u00111G\u0005\u0005\u0003k\tIBA\u0002H\u000bR\u000bAbZ3u%\u00164\u0018n]5p]N$B!a\u000f\u0002HA!\u0011QHA\"\u001b\t\tyD\u0003\u0003\u0002B\u0005e\u0011\u0001B2pe\u0016LA!!\u0012\u0002@\tA!+Z:q_:\u001cX\rC\u0004\u0002J-\u0001\r!a\u0013\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\r\u0005\u0003\u0002N\u0005mc\u0002BA(\u0003/\u00022!!\u0015$\u001b\t\t\u0019FC\u0002\u0002V}\ta\u0001\u0010:p_Rt\u0014bAA-G\u00051\u0001K]3eK\u001aLA!!\u0018\u0002`\t11\u000b\u001e:j]\u001eT1!!\u0017$Q\u0011\t9%a\u0019\u0011\t\u0005\u0015\u00141O\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005\u0011\u0011\u000e\u001a\u0006\u0005\u0003[\ny'\u0001\u0005qYVl'-\u001b8h\u0015\r\t\thG\u0001\tI\u0016\u0004Hn\\=ji&!\u0011QOA4\u0005\u001dIE\rU1sC6D\u0003\"a\u0012\u0002z\u0005%\u0012q\u0010\t\u0005\u0003/\tY(\u0003\u0003\u0002~\u0005e!!\u0003)bi\"\u0004\u0016M]1nC\t\tI\u0005K\u0004\f\u0003+\tI#a!\"\u0005\u0005\u0015\u0015aJ\u0018|i\u0016l\u0007\u000f\\1uK&#'H\f\u0016SK2,\u0017m]3\\=>jSLK?0e\u00164\u0018n]5p]ND3aCA\u0019\u0003I9W\r\u001e*fm&\u001c\u0018n\u001c8D_:$XM\u001c;\u0015\r\u0005m\u0012QRAJ\u0011\u001d\tI\u0005\u0004a\u0001\u0003\u0017BC!!$\u0002d!B\u0011QRA=\u0003S\ty\bC\u0004\u0002\u00162\u0001\r!a&\u0002\u0015I,g/[:j_:LE\rE\u0002#\u00033K1!a'$\u0005\rIe\u000e\u001e\u0015\t\u0003'\u000bI(!\u000b\u0002 \u0006\u0012\u0011Q\u0013\u0015\b\u0019\u0005U\u0011\u0011FARC\t\t)+\u0001\u001f0wR,W\u000e\u001d7bi\u0016LEM\u000f\u0018+%\u0016dW-Y:f7z{S&\u0018\u0016~_I,g/[:j_:\u001cxf\u001f:fm&\u001c\u0018n\u001c8JIv|3m\u001c8uK:$\bf\u0001\u0007\u00022\u0005i1M]3bi\u00164VM]:j_:$b!a\u000f\u0002.\u0006M\u0006bBA%\u001b\u0001\u0007\u00111\n\u0015\u0005\u0003[\u000b\u0019\u0007\u000b\u0005\u0002.\u0006e\u0014\u0011FA@\u0011\u001d\t),\u0004a\u0001\u0003o\u000b1B^3sg&|gNV5foB!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>V\tQA^5foNLA!!1\u0002<\nYa+\u001a:tS>tg+[3xQ\u001di\u0011QCA\u0015\u0003\u000b\f#!a2\u0002M=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|c/\u001a:tS>t7\u000fK\u0002\u000e\u0003\u0017\u0004B!a\u0006\u0002N&!\u0011qZA\r\u0005\u0011\u0001vj\u0015+\u0002\u001fI,7\u000f^8sKJ+g/[:j_:$b!a\u000f\u0002V\u0006m\u0007bBA%\u001d\u0001\u0007\u00111\n\u0015\u0005\u0003+\f\u0019\u0007\u000b\u0005\u0002V\u0006e\u0014\u0011FA@\u0011\u001d\t)J\u0004a\u0001\u0003/C\u0003\"a7\u0002z\u0005%\u0012q\u0014\u0015\b\u001d\u0005U\u0011\u0011FAqC\t\t\u0019/\u0001\u001f0wR,W\u000e\u001d7bi\u0016LEM\u000f\u0018+%\u0016dW-Y:f7z{S&\u0018\u0016~_I,g/[:j_:\u001cxf\u001f:fm&\u001c\u0018n\u001c8JIv|#/Z:u_J,\u0007f\u0001\b\u0002hB!\u0011qCAu\u0013\u0011\tY/!\u0007\u0003\u0007A+F+\u0001\beK2,G/\u001a*fm&\u001c\u0018n\u001c8\u0015\r\u0005m\u0012\u0011_A|\u0011\u001d\tIe\u0004a\u0001\u0003\u0017BC!!=\u0002d!B\u0011\u0011_A=\u0003S\ty\bC\u0004\u0002\u0016>\u0001\r!a&)\u0011\u0005]\u0018\u0011PA\u0015\u0003?CsaDA\u000b\u0003S\ti0\t\u0002\u0002\u0000\u0006!tf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSp\f:fm&\u001c\u0018n\u001c8t_m\u0014XM^5tS>t\u0017\nZ?)\u0007=\u0011\u0019\u0001\u0005\u0003\u0002\u0018\t\u0015\u0011\u0002\u0002B\u0004\u00033\u0011a\u0001R#M\u000bR+\u0015a\u00043fY\u0016$XMU3wSNLwN\\:\u0015\r\u0005m\"Q\u0002B\n\u0011\u001d\tI\u0005\u0005a\u0001\u0003\u0017BCA!\u0004\u0002d!B!QBA=\u0003S\ty\bC\u0004\u0003\u0016A\u0001\rAa\u0006\u0002\u0017I,g/[:j_:LEm\u001d\t\u0007\u00053\u0011\u0019#a&\u000e\u0005\tm!\u0002\u0002B\u000f\u0005?\tA!\u001e;jY*\u0011!\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003&\tm!\u0001\u0002'jgRDs\u0001EA\u000b\u0003S\t\u0019\tK\u0002\u0011\u0005\u0007\tqaY8na\u0006\u0014X\r\u0006\u0005\u00030\tU\"1\bB)!\u0011\tIL!\r\n\t\tM\u00121\u0018\u0002\u001b)\u0016l\u0007\u000f\\1uK\u000e{g\u000e^3oi\u0006sG\r\u0015:fm&|Wo\u001d\u0005\b\u0003\u0013\n\u0002\u0019AA&Q\u0011\u0011)$a\u0019)\u0011\tU\u0012\u0011PA\u0015\u0003\u007fBq!!&\u0012\u0001\u0004\t9\n\u000b\u0005\u0003<\t}\u0012\u0011FAP!\u0011\t9B!\u0011\n\t\t\r\u0013\u0011\u0004\u0002\u000b#V,'/\u001f)be\u0006l\u0007\u0006\u0003B\u001e\u0005\u000f\nIC!\u0014\u0011\t\u0005]!\u0011J\u0005\u0005\u0005\u0017\nIB\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-\t\u0002\u0003P\u0005\t\u0001\u0007C\u0004\u0003TE\u0001\r!a&\u0002\u0019Q|'+\u001a<jg&|g.\u00133)\u0011\tE#qHA\u0015\u0005/\n#Aa\u0015)\u0011\tE#qIA\u0015\u0005\u001bBs!EA\u000b\u0003S\u0011i&\t\u0002\u0003`\u0005)sf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSpL2p[B\f'/\u001a\u0015\u0004#\u0005E\u0012\u0001F4fiJ+7o\u001c7vi&|gnQ8oi\u0016DH\u000f\u0006\u0003\u0003h\tM\u0004\u0003\u0002B5\u0005_j!Aa\u001b\u000b\t\t5\u00141N\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\tE$1\u000e\u0002\u0012%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\bbBA%%\u0001\u0007\u00111J\u0001\u0011O\u0016$H+Z7qY\u0006$X-Q:Eg2$B!a\u0013\u0003z!9!1P\nA\u0002\tu\u0014\u0001\u0003;f[Bd\u0017\r^3\u0011\t\t}$1Q\u0007\u0003\u0005\u0003S1!!\u0003\u001a\u0013\u0011\u0011)I!!\u0003\u000fI+G.Z1tK\"\u001a\u0001A!#\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bS1Aa$z\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005'\u0013iI\u0001\u0006D_:$(o\u001c7mKJDs\u0001\u0001BL\u0003S\u0011i\n\u0005\u0003\u0002\u0018\te\u0015\u0002\u0002BN\u00033\u0011\u0001bQ8ogVlWm\u001d\u0017\u0003\u0005?\u000b#A!)\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007f\u0002\u0001\u0003&\u0006%\"1\u0016\t\u0005\u0003/\u00119+\u0003\u0003\u0003*\u0006e!\u0001\u0003)s_\u0012,8-Z:-\u0005\t}\u0005f\u0002\u0001\u0002\u0016\u0005%\"qV\u0011\u0003\u0005c\u000b1b\f<feNLwN\\5oO\u0002")
public class TemplateVersioningResource
implements Logging {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;
    private final ConfigurationRepository configurationRepository;
    private final ScmTemplateStorageService templateStorageListener;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateVersioningResource templateVersioningResource = this;
        synchronized (templateVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/settings")
    public TemplateVersioningSettings getTemplateVersionoingSettings() {
        return (TemplateVersioningSettings)this.configurationRepository.read(TemplateVersioningSettings$.MODULE$.TEMPLATE_VERSIONING_ID());
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        String user = Permissions.getAuthenticatedUserName();
        Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.templateStorageListener.createNewVersion(templateId, versionView.name(), versionView.description(), user)).map((Function1 & Serializable & scala.Serializable)tagName -> {
            Try r = (Try)$this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion((String)tagName, versionView.description(), user));
            return new Tuple2(tagName, (Object)r);
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Try try_;
            Try r;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null || (r = (Try)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            Try try_2 = try_ = r;
            return try_2;
        });
        return Response.ok((Object)result.fold((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreateVersionResponse createVersionResponse;
            Throwable throwable = x0$1;
            if (throwable instanceof TemplateVersioningException) {
                TemplateVersioningException templateVersioningException = (TemplateVersioningException)((Object)((Object)throwable));
                String msg = templateVersioningException.msg();
                int statusCode = templateVersioningException.statusCode();
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable & scala.Serializable)() -> templateVersioningException);
                createVersionResponse = new CreateVersionResponse(false, msg, statusCode);
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable & scala.Serializable)() -> throwable2);
                createVersionResponse = new CreateVersionResponse(false, throwable2.getMessage(), 500);
            } else {
                throw new MatchError((Object)throwable);
            }
            return createVersionResponse;
        }, (Function1 & Serializable & scala.Serializable)id -> new CreateVersionResponse(true, id.toString(), CreateVersionResponse$.MODULE$.$lessinit$greater$default$3()))).build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        Release template = this.releaseService.findById(templateId);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, template);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TRIGGERS, template);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, template);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}")
    public Response deleteRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevision(templateId, revisionId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response deleteRevisions(@PathParam(value="templateId") @IdParam String templateId, List<Object> revisionIds) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevisions(templateId, (Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(revisionIds).asScala()));
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @DefaultValue(value="0") @QueryParam(value="revisionId") int revisionId, @DefaultValue(value="0") @QueryParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = revisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        Release toRevision = toRevisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(toRevisionId, this.getResolutionContext(templateId));
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    public ResolutionContext getResolutionContext(String templateId) {
        return Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
    }

    private String getTemplateAsDsl(Release template) {
        return this.dslExporter.exportTemplate(template, this.dslExporter.exportTemplate$default$2());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService, ConfigurationRepository configurationRepository, ScmTemplateStorageService templateStorageListener) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
        this.configurationRepository = configurationRepository;
        this.templateStorageListener = templateStorageListener;
        Logging.$init$((Logging)this);
    }
}

