# Dot map access to dicts

import java.util as util

def isDict(value):
    return isinstance(value, dict) or isinstance(value, util.Map)

def isList(value):
    return isinstance(value, list) or isinstance(value, util.List) or isinstance(value, set) or isinstance(value, util.Set)

class Map(dict):
    def __init__(self, *args, **kwargs):
        super(Map, self).__init__(*args, **kwargs)
        for arg in args:
            if isDict(arg):
                for k, v in arg.iteritems():
                    if isDict(v):
                        v = Map(v)
                    if isList(v):
                        self.__convert(v)
                    self[k] = v

        if kwargs:
            for k, v in kwargs.iteritems():
                if isDict(v):
                    v = Map(v)
                elif isList(v):
                    self.__convert(v)
                self[k] = v

    def __convert(self, v):
        for elem in xrange(0, len(v)):
            if isDict(v[elem]):
                v[elem] = Map(v[elem])
            elif isList(v[elem]):
                self.__convert(v[elem])

    def __getattr__(self, attr):
        return self.get(attr)

    def __setattr__(self, key, value):
        self.__setitem__(key, value)

    def __setitem__(self, key, value):
        super(Map, self).__setitem__(key, value)
        self.__dict__.update({key: value})

    def __delattr__(self, item):
        self.__delitem__(item)

    def __delitem__(self, key):
        super(Map, self).__delitem__(key)
        del self.__dict__[key]