/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.events.handler;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.TriggerActivity;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.notifications.GenericSystemNotification;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.NotificationTrigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.triggers.activity.TriggerActivityLogsService;
import com.xebialabs.xlrelease.triggers.events.TriggerAutoDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailureEvent;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.views.LogsFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\b\u0010\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!)\u0005A!A!\u0002\u00131\u0005\"\u0002'\u0001\t\u0003i\u0005\u0002C+\u0001\u0011\u000b\u0007I\u0011\u0002,\t\u0011\u0015\u0004\u0001R1A\u0005\nYCQA\u001a\u0001\u0005\u0002\u001dDQ!\u001e\u0001\u0005\nYDQ\u0001\u001f\u0001\u0005\neDaa \u0001\u0005\n\u0005\u0005\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0002\u001b)JLwmZ3s\r\u0006LG.\u001e:f\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003!E\tq\u0001[1oI2,'O\u0003\u0002\u0013'\u00051QM^3oiNT!\u0001F\u000b\u0002\u0011Q\u0014\u0018nZ4feNT!AF\f\u0002\u0013ad'/\u001a7fCN,'B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013!B:mMRR'\"\u0001\u0015\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AK\u0013\u0003\u000f1{wmZ5oO\u0006qAO]5hO\u0016\u00148+\u001a:wS\u000e,\u0007CA\u00171\u001b\u0005q#BA\u0018\u0014\u0003\u001d\u0019XM\u001d<jG\u0016L!!\r\u0018\u0003\u001dQ\u0013\u0018nZ4feN+'O^5dK\u0006QBO]5hO\u0016\u0014\u0018i\u0019;jm&$\u0018\u0010T8hgN+'O^5dKB\u0011AgN\u0007\u0002k)\u0011agE\u0001\tC\u000e$\u0018N^5us&\u0011\u0001(\u000e\u0002\u001b)JLwmZ3s\u0003\u000e$\u0018N^5us2{wm]*feZL7-Z\u0001\u0015G>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005mjT\"\u0001\u001f\u000b\u0005=*\u0012B\u0001 =\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\u0006AQM^3oi\n+8\u000f\u0005\u0002B\u00076\t!I\u0003\u0002\u0013+%\u0011AI\u0011\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018a\u00058pi&4\u0017nY1uS>t7+\u001a:wS\u000e,\u0007CA$K\u001b\u0005A%BA%\u0016\u00035qw\u000e^5gS\u000e\fG/[8og&\u00111\n\u0013\u0002\u0014\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r9\u0003\u0016KU*U!\ty\u0005!D\u0001\u0010\u0011\u0015Yc\u00011\u0001-\u0011\u0015\u0011d\u00011\u00014\u0011\u0015Id\u00011\u0001;\u0011\u0015yd\u00011\u0001A\u0011\u0015)e\u00011\u0001G\u0003m\u0019w.\u001e8uC\ndW\r\u0016:jO\u001e,'/Q2uSZLG/_(qgV\tq\u000bE\u0002Y;~k\u0011!\u0017\u0006\u00035n\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005q{\u0012AC2pY2,7\r^5p]&\u0011a,\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002c+\u00051Am\\7bS:L!\u0001Z1\u0003\u001fQ\u0013\u0018nZ4fe\u0006\u001bG/\u001b<jif\fA\u0003\u001e:jO\u001e,'OR1jYV\u0014X-\u0012<f]R\u001c\u0018!F8o)JLwmZ3s\r\u0006LG.\u001e:f\u000bZ,g\u000e\u001e\u000b\u0003Q.\u0004\"AH5\n\u0005)|\"\u0001B+oSRDQ\u0001\\\u0005A\u00025\fQ!\u001a<f]R\u0004\"A\\8\u000e\u0003EI!\u0001]\t\u0003'Q\u0013\u0018nZ4fe\u001a\u000b\u0017\u000e\\;sK\u00163XM\u001c;)\u0005%\u0011\bCA!t\u0013\t!(I\u0001\bBgft7mU;cg\u000e\u0014\u0018NY3\u0002[\rDWmY6JM\u000e{gn]3dkRLg/\u001a+sS\u001e<WM\u001d$bS2,(/Z:MS6LGOU3bG\",G\r\u0006\u0002io\")AN\u0003a\u0001[\u0006\u0011bn\u001c;jMf\u001c\u0016p\u001d;f[\u0006#W.\u001b8t)\tA'\u0010C\u0003|\u0017\u0001\u0007A0A\u0004ue&<w-\u001a:\u0011\u0005\u0001l\u0018B\u0001@b\u0005\u001d!&/[4hKJ\f!e\u00195fG.Le-\u00117m)JLwmZ3s\u000bZ,g\u000e^:Be\u00164\u0015-\u001b7ve\u0016\u001cH\u0003BA\u0002\u0003\u0013\u00012AHA\u0003\u0013\r\t9a\b\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001b\t!eY8v]R\f'\r\\3Ue&<w-\u001a:BGRLg/\u001b;z\u0019><WI\u001c;sS\u0016\u001c\bCBA\b\u00033\tY\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006L1AXA\t!\r\u0001\u0017QD\u0005\u0004\u0003?\t'\u0001E!di&4\u0018\u000e^=M_\u001e,e\u000e\u001e:z\u0003\u0015:W\r^\"pk:$\u0018M\u00197f)JLwmZ3s\u0003\u000e$\u0018N^5us2{w-\u00128ue&,7\u000f\u0006\u0004\u0002\u000e\u0005\u0015\u0012q\b\u0005\b\u0003Oi\u0001\u0019AA\u0015\u0003%!(/[4hKJLE\r\u0005\u0003\u0002,\u0005eb\u0002BA\u0017\u0003k\u00012!a\f \u001b\t\t\tDC\u0002\u00024m\ta\u0001\u0010:p_Rt\u0014bAA\u001c?\u00051\u0001K]3eK\u001aLA!a\u000f\u0002>\t11\u000b\u001e:j]\u001eT1!a\u000e \u0011\u001d\t\t%\u0004a\u0001\u0003\u0007\n\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003\u000b\n)&\u0004\u0002\u0002H)\u0019!-!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005I\u0006$\u0018M\u0003\u0003\u0002P\u0005E\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005M\u0013aA8sO&!\u0011qKA$\u0005!\u0001\u0016mZ3bE2,\u0007f\u0001\u0001\u0002\\A\u0019\u0011)!\u0018\n\u0007\u0005}#IA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0015\u0004\u0001\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\t\u0005%\u0014QJ\u0001\u000bgR,'/Z8usB,\u0017\u0002BA7\u0003O\u0012\u0011bQ8na>tWM\u001c;")
public class TriggerFailureEventHandler
implements Logging {
    private List<TriggerActivity> countableTriggerActivityOps;
    private List<TriggerActivity> triggerFailureEvents;
    private final TriggerService triggerService;
    private final TriggerActivityLogsService triggerActivityLogsService;
    private final ConfigurationService configurationService;
    private final XLReleaseEventBus eventBus;
    private final NotificationService notificationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerFailureEventHandler triggerFailureEventHandler = this;
        synchronized (triggerFailureEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private List<TriggerActivity> countableTriggerActivityOps$lzycompute() {
        TriggerFailureEventHandler triggerFailureEventHandler = this;
        synchronized (triggerFailureEventHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.countableTriggerActivityOps = new .colon.colon((Object)TriggerActivity.TRIGGER_ENABLED, (List)new .colon.colon((Object)TriggerActivity.TRIGGER_DISABLED, (List)new .colon.colon((Object)TriggerActivity.TRIGGER_EXECUTED, (List)new .colon.colon((Object)TriggerActivity.TRIGGER_FAILED, (List)new .colon.colon((Object)TriggerActivity.TRIGGER_FILTER_FAILED, (List)Nil$.MODULE$)))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.countableTriggerActivityOps;
    }

    private List<TriggerActivity> countableTriggerActivityOps() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.countableTriggerActivityOps$lzycompute();
        }
        return this.countableTriggerActivityOps;
    }

    private List<TriggerActivity> triggerFailureEvents$lzycompute() {
        TriggerFailureEventHandler triggerFailureEventHandler = this;
        synchronized (triggerFailureEventHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.triggerFailureEvents = new .colon.colon((Object)TriggerActivity.TRIGGER_FAILED, (List)new .colon.colon((Object)TriggerActivity.TRIGGER_FILTER_FAILED, (List)Nil$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.triggerFailureEvents;
    }

    private List<TriggerActivity> triggerFailureEvents() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.triggerFailureEvents$lzycompute();
        }
        return this.triggerFailureEvents;
    }

    @AsyncSubscribe
    public void onTriggerFailureEvent(TriggerFailureEvent event) {
        this.logger().trace((Function0 & Serializable)() -> "Received TriggerFailureEvent event for trigger [" + event.trigger().getId() + "]");
        this.checkIfConsecutiveTriggerFailuresLimitReached(event);
    }

    private void checkIfConsecutiveTriggerFailuresLimitReached(TriggerFailureEvent event) {
        FeatureSettings limits = this.configurationService.getFeatureSettings(Limits$.MODULE$.TYPE_LIMITS());
        int limitsConsecutiveTriggerFailures = BoxesRunTime.unboxToInt((Object)limits.getProperty(Limits$.MODULE$.CONSECUTIVE_TRIGGER_FAILURES()));
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limits.getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled) {
            Pageable pageable = Pageable.ofSize((int)limitsConsecutiveTriggerFailures);
            java.util.List<ActivityLogEntry> countableTriggerActivityLogEntries = this.getCountableTriggerActivityLogEntries(event.trigger().getId(), pageable);
            boolean isConsecutiveTriggerFailuresLimitReachable = countableTriggerActivityLogEntries.size() >= limitsConsecutiveTriggerFailures;
            boolean allTriggerEventsAreFailures = this.checkIfAllTriggerEventsAreFailures(countableTriggerActivityLogEntries);
            if (isConsecutiveTriggerFailuresLimitReachable && allTriggerEventsAreFailures) {
                this.logger().warn((Function0 & Serializable)() -> "Trigger [" + event.trigger().getId() + "] reached the maximum configured number of consecutive failures: " + limitsConsecutiveTriggerFailures + ". Automatically disabling the trigger now.");
                this.triggerService.disableTriggerAuto(event.trigger().getId());
                this.eventBus.publish((XLReleaseEvent)new TriggerAutoDisabledEvent(event.trigger()));
                this.notifySystemAdmins(event.trigger());
                return;
            }
            return;
        }
    }

    private void notifySystemAdmins(Trigger trigger) {
        String emailSubject = "[Release] Trigger was disabled because of consecutive failures";
        String emailBody = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |Disabled trigger '%s' automatically due to reaching the maximum configured number of consecutive failures.\n        |\n        |Please fix the cause before enabling the trigger. Check [activity logs](%s#/trigger-management/%s/logs) for more details.\n        |"))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{trigger.getTitle(), ServerConfiguration.getInstance().getServerUrl(), Ids.getName((String)trigger.getId())}));
        this.notificationService.notify((NotificationTrigger)new GenericSystemNotification(emailSubject, emailBody));
    }

    private boolean checkIfAllTriggerEventsAreFailures(java.util.List<ActivityLogEntry> countableTriggerActivityLogEntries) {
        return countableTriggerActivityLogEntries.stream().allMatch(entry -> this.triggerFailureEvents().contains((Object)TriggerActivity.safeValueOf(entry.getActivityType())));
    }

    private java.util.List<ActivityLogEntry> getCountableTriggerActivityLogEntries(String triggerId, Pageable pageable) {
        return this.triggerActivityLogsService.getFilteredLogs(triggerId, LogsFilters.ALL, this.countableTriggerActivityOps(), pageable);
    }

    public TriggerFailureEventHandler(TriggerService triggerService, TriggerActivityLogsService triggerActivityLogsService, ConfigurationService configurationService, XLReleaseEventBus eventBus, NotificationService notificationService) {
        this.triggerService = triggerService;
        this.triggerActivityLogsService = triggerActivityLogsService;
        this.configurationService = configurationService;
        this.eventBus = eventBus;
        this.notificationService = notificationService;
        Logging.$init$((Logging)this);
    }
}

