package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.security.XLReleasePermissions._
import com.xebialabs.xlrelease.security.sql.{EvictAllEvent, SecurityCacheEviction}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

import java.util.Optional


@Component
class XLRelease960TriggerPermissionsUpgrade @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                         @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                                         securityCacheEviction: Optional[SecurityCacheEviction])
  extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.6.0#4")

  override def doUpgrade(): Boolean = {
    // Update trigger permission on folders only
    jdbcTemplate.update(
      s"""UPDATE XL_ROLE_PERMISSIONS
         | SET PERMISSION_NAME = '${EDIT_TRIGGER.getPermissionName}'
         | WHERE PERMISSION_NAME = '${EDIT_TEMPLATE_TRIGGERS.getPermissionName}'
         |  AND CI_ID NOT IN (
         |      SELECT r.CI_UID
         |      FROM XLR_RELEASES r
         |      JOIN XLR_FOLDERS f ON r.FOLDER_CI_UID = f.CI_UID
         |      WHERE f.FOLDER_ID = '/'
         |  )
         |  """.stripMargin
    )
    securityCacheEviction.map(_.onEvictAll(EvictAllEvent()))
    true
  }

}
