/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.triggers.action.TriggerActionExecuted;
import com.xebialabs.xlrelease.triggers.action.TriggerActionResult;
import com.xebialabs.xlrelease.triggers.action.TriggerActionSkipped;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerEnabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerExecutedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerSkippedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledTriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionResult;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B+\u0001\t\u00031\u0006\"\u00020\u0001\t\u0003y\u0006\"B7\u0001\t\u0003q\u0007\"B9\u0001\t\u0003\u0011\b\"CA\u001a\u0001E\u0005I\u0011AA\u001b\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002j\u0001!I!a\u001b\t\u0013\u0005E\u0004!%A\u0005\n\u0005M\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\ti\b\u0001C\u0005\u0003_Cq!a.\u0001\t\u0013\tILA\tUe&<w-\u001a:Pa\u0016\u0014\u0018\r^5p]NT!!\u0006\f\u0002\r\u0005\u001cGo\u001c:t\u0015\t9\u0002$\u0001\u0005ue&<w-\u001a:t\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\t1&\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0003FA\u0004M_\u001e<\u0017N\\4\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021g5\t\u0011G\u0003\u000231\u0005Q!/\u001a9pg&$xN]=\n\u0005Q\n$!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005A:\u0014B\u0001\u001d2\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u0007KZ,g\u000e^:\n\u0005}b$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001BO]5hO\u0016\u0014H*\u001b4fGf\u001cG.\u001a\t\u0004\u0005\u001eKU\"A\"\u000b\u0005\u0011+\u0015\u0001B5na2T!A\u0012\f\u0002\u000fM,'O^5dK&\u0011\u0001j\u0011\u0002\u0011)JLwmZ3s\u0019&4WmY=dY\u0016\u0004\"AS'\u000e\u0003-S!\u0001\u0014\r\u0002\r\u0011|W.Y5o\u0013\tq5JA\u0004Ue&<w-\u001a:\u00029\r|gNZ5hkJ\fG/[8o-\u0006\u0014\u0018.\u00192mKN+'O^5dKB\u0011\u0011kU\u0007\u0002%*\u0011a\tG\u0005\u0003)J\u0013AdQ8oM&<WO]1uS>tg+\u0019:jC\ndWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0007/fS6\fX/\u0011\u0005a\u0003Q\"\u0001\u000b\t\u000b92\u0001\u0019A\u0018\t\u000bU2\u0001\u0019\u0001\u001c\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00013\u0001\u0019A!\t\u000b=3\u0001\u0019\u0001)\u0002\t\u0019Lg\u000e\u001a\u000b\u0003\u0013\u0002DQ!Y\u0004A\u0002\t\f\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0005\rTgB\u00013i!\t)'%D\u0001g\u0015\t9g$\u0001\u0004=e>|GOP\u0005\u0003S\n\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011NI\u0001\u000bC\u0012$GK]5hO\u0016\u0014HCA%p\u0011\u0015\u0001\b\u00021\u0001J\u0003\u001d!(/[4hKJ\fQ\"\u001e9eCR,GK]5hO\u0016\u0014H#C%tkZ\\Xp`A\u0002\u0011\u0015!\u0018\u00021\u0001J\u0003!y'/[4j]\u0006d\u0007\"\u00029\n\u0001\u0004I\u0005\"B<\n\u0001\u0004A\u0018\u0001\u0003<bY&$\u0017\r^3\u0011\u0005\u0005J\u0018B\u0001>#\u0005\u001d\u0011un\u001c7fC:DQ\u0001`\u0005A\u0002a\f!\"Z7ji\u00163XM\u001c;t\u0011\u0015q\u0018\u00021\u0001y\u0003!Ig\u000e^3s]\u0006d\u0007BBA\u0001\u0013\u0001\u0007\u00010A\rdQ\u0016\u001c7NU3gKJ,gnY3QKJl\u0017n]:j_:\u001c\b\"CA\u0003\u0013A\u0005\t\u0019AA\u0004\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0006\u0003\u0013\t\u0019B\u0019\b\u0005\u0003\u0017\tyAD\u0002f\u0003\u001bI\u0011aI\u0005\u0004\u0003#\u0011\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9BA\u0002TKFT1!!\u0005#Q\rI\u00111\u0004\t\u0005\u0003;\ty#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003K\t9#\u0001\u0003d_J,'\u0002BA\u0015\u0003W\t!\"\\5de>lW\r^3s\u0015\t\ti#\u0001\u0002j_&!\u0011\u0011GA\u0010\u0005\u0015!\u0016.\\3e\u0003])\b\u000fZ1uKR\u0013\u0018nZ4fe\u0012\"WMZ1vYR$s'\u0006\u0002\u00028)\"\u0011qAA\u001dW\t\tY\u0004\u0005\u0003\u0002>\u0005\u0015SBAA \u0015\u0011\t\t%a\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0011E%!\u0011qIA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eI\u0016dW\r^3Ue&<w-\u001a:\u0015\t\u00055\u00131\u000b\t\u0004C\u0005=\u0013bAA)E\t!QK\\5u\u0011\u0015\u00018\u00021\u0001JQ\rY\u00111D\u0001\bKb,7-\u001e;f)\u0015I\u00151LA/\u0011\u0015\u0001H\u00021\u0001J\u0011\u001d\ty\u0006\u0004a\u0001\u0003C\n\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0007\t\u000b\u0019'C\u0002\u0002f\r\u0013q\u0003\u0016:jO\u001e,'/\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;)\u00071\tY\"A\u0007f]\u0006\u0014G.\u001a+sS\u001e<WM\u001d\u000b\u0007\u0003\u001b\ni'a\u001c\t\u000bAl\u0001\u0019A%\t\u000fql\u0001\u0013!a\u0001q\u00069RM\\1cY\u0016$&/[4hKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003kR3\u0001_A\u001d\u0003A1\u0018\r\\5eCR,gi\u001c7eKJLE\r\u0006\u0003\u0002N\u0005m\u0004\"\u00029\u0010\u0001\u0004I\u0015aD2iK\u000e\\g+\u00197jI\u0006$\u0018n\u001c8\u0015\r\u00055\u0013\u0011QAB\u0011\u0015\u0001\b\u00031\u0001J\u0011\u001d\t)\t\u0005a\u0001\u0003\u000f\u000bA!\\:hgB1\u0011\u0011RAJ\u0003/k!!a#\u000b\t\u00055\u0015qR\u0001\u0005kRLGN\u0003\u0002\u0002\u0012\u0006!!.\u0019<b\u0013\u0011\t)*a#\u0003\t1K7\u000f\u001e\t\u0005\u00033\u000bY+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0005\u0003C\u000b\u0019+A\u0002ba&TA!!*\u0002(\u00061\u0001\u000f\\;hS:T1!!+\u001b\u0003!!W\r\u001d7ps&$\u0018\u0002BAW\u00037\u0013\u0011CV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4f)\u0019\ti%!-\u00026\"1\u00111W\tA\u0002%\u000b!aY5\t\r\u0005\u0005\u0011\u00031\u0001y\u0003=)\b\u000fZ1uKZ\u000b'/[1cY\u0016\u001cH\u0003BA'\u0003wCQ\u0001\u001d\nA\u0002%\u0003")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final ConfigurationVariableService configurationVariableService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    public Trigger addTrigger(Trigger trigger) {
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger, true);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        return addedTrigger;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate2, boolean emitEvents, boolean internal, boolean checkReferencePermissions, scala.collection.immutable.Seq<String> properties) {
        Trigger updated;
        block5: {
            Trigger trigger2;
            this.trace((Function0<Object>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updating trigger " + original + " properties: '" + properties.mkString(",") + "'\n         |previous: " + package$.MODULE$.TriggerExtensions(original).toJson() + "\n         |new: " + package$.MODULE$.TriggerExtensions(trigger).toJson())));
            if (properties.isEmpty()) {
                CollectionConverters$.MODULE$.ListHasAsScala(trigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
                    trigger.setProperty(internalProperty, original.getProperty(internalProperty));
                    return BoxedUnit.UNIT;
                });
                trigger2 = trigger;
            } else {
                trigger2 = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            }
            Trigger toUpdate = trigger2;
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            if (validate2) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate, checkReferencePermissions);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                boolean emitStateEvent = emitEvents && (!Objects.equal((Object)BoxesRunTime.boxToBoolean((boolean)original.isEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)updated.isEnabled())) || properties.contains((Object)"enabled"));
                this.enableTrigger(updated, emitStateEvent);
            }
            if (!emitEvents) break block5;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public scala.collection.immutable.Seq<String> updateTrigger$default$7() {
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        Try result;
        Trigger x$1 = trigger;
        GlobalVariables x$2 = this.configurationVariableService.resolveFromCi$default$2();
        Function1 x$3 = this.configurationVariableService.resolveFromCi$default$3((ConfigurationItem)x$1, x$2);
        this.configurationVariableService.resolveFromCi((ConfigurationItem)x$1, x$2, x$3);
        TriggerExecutionResult<Trigger> triggerExecutionResult = this.triggerLifecycle.execute(trigger, executionContext);
        if (triggerExecutionResult == null) {
            throw new MatchError(triggerExecutionResult);
        }
        Trigger maybeExecutedTrigger = triggerExecutionResult.trigger();
        Try<TriggerActionResult> result2 = triggerExecutionResult.results();
        Tuple2 tuple2 = new Tuple2((Object)maybeExecutedTrigger, result2);
        Trigger maybeExecutedTrigger2 = (Trigger)tuple2._1();
        Try try_ = result = (Try)tuple2._2();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.eventBus.publish((XLReleaseEvent)new TriggerFailedEvent(trigger, e.getMessage(), executionContext.getExecutionDataId()));
            throw e;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            TriggerActionResult actionResult = (TriggerActionResult)success.value();
            TriggerActionResult triggerActionResult = actionResult;
            if (triggerActionResult instanceof TriggerActionExecuted) {
                TriggerActionExecuted triggerActionExecuted = (TriggerActionExecuted)triggerActionResult;
                String result3 = triggerActionExecuted.result();
                this.eventBus.publish((XLReleaseEvent)new TriggerExecutedEvent(maybeExecutedTrigger2, result3, executionContext.getExecutionDataId()));
            } else if (triggerActionResult instanceof TriggerActionSkipped) {
                TriggerActionSkipped triggerActionSkipped = (TriggerActionSkipped)triggerActionResult;
                String message = triggerActionSkipped.message();
                if (!(executionContext instanceof ScheduledTriggerExecutionContext)) {
                    this.eventBus.publish((XLReleaseEvent)new TriggerSkippedEvent(maybeExecutedTrigger2, message, executionContext.getExecutionDataId()));
                }
            }
            return maybeExecutedTrigger2;
        }
        throw new MatchError((Object)try_);
    }

    private void enableTrigger(Trigger trigger, boolean emitEvents) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, true);
            if (emitEvents) {
                this.eventBus.publish((XLReleaseEvent)new TriggerEnabledEvent(trigger));
                return;
            }
            return;
        }
        this.triggerLifecycle.disable(trigger);
        if (emitEvents) {
            this.eventBus.publish((XLReleaseEvent)new TriggerDisabledEvent(trigger));
            return;
        }
    }

    private boolean enableTrigger$default$2() {
        return true;
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
            return;
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(msgs).asScala().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (CollectionConverters$.MODULE$.ListHasAsScala(trigger.get$validationMessages()).asScala().nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci, boolean checkReferencePermissions) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci, checkReferencePermissions));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$2 -> !x$2.isPassword())).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$3)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$4)))).toList()).asJava());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$4) {
        return x$4.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle, ConfigurationVariableService configurationVariableService) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        this.configurationVariableService = configurationVariableService;
        Logging.$init$((Logging)this);
    }
}

