/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.status.TriggerExecutionStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.StreamUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005}3q!\u0002\u0004\u0011\u0002\u0007\u00051\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003L\u0001\u0011\u0005A\nC\u0003Z\u0001\u0011%!LA\u0007Ue&<w-\u001a:NCB\u0004XM\u001d\u0006\u0003\u000f!\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011\u0011BC\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0006\r\u0003!!(/[4hKJ\u001c(BA\u0007\u000f\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0010!\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0002CA\u000b\u001e\u0013\tqbC\u0001\u0003V]&$\u0018!\u0004;sS\u001e<WM]'baB,'/\u0006\u0002\"\u007fU\t!\u0005E\u0003\u0016G\u0015b\u0013'\u0003\u0002%-\tIa)\u001e8di&|gN\r\t\u0003M)j\u0011a\n\u0006\u0003Q%\n1a]9m\u0015\tIA\"\u0003\u0002,O\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\u0004\"!L\u0018\u000e\u00039R!aB\u0014\n\u0005Ar#!\u0005$pY\u0012,'\u000fU3sg&\u001cH/\u001a8dKB\u0019!gO\u001f\u000e\u0003MR!\u0001N\u001b\u0002\t\r|'/\u001a\u0006\u0003m]\nAA\u001b3cG*\u0011\u0001(O\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!(A\u0002pe\u001eL!\u0001P\u001a\u0003\u0013I{w/T1qa\u0016\u0014\bC\u0001 @\u0019\u0001!Q\u0001\u0011\u0002C\u0002\u0005\u0013\u0011\u0001V\t\u0003\u0005\u0016\u0003\"!F\"\n\u0005\u00113\"a\u0002(pi\"Lgn\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u00112\ta\u0001Z8nC&t\u0017B\u0001&H\u0005\u001d!&/[4hKJ\f!\u0003\u001e:jO\u001e,'/\u00133S_^l\u0015\r\u001d9feV\tQ\nE\u00023w9\u0003\"a\u0014,\u000f\u0005A#\u0006CA)\u0017\u001b\u0005\u0011&BA*\u0013\u0003\u0019a$o\\8u}%\u0011QKF\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V-\u00059\"/Z<sSR,w+\u001b;i\u001d\u0016<HK]5hO\u0016\u0014\u0018\n\u001a\u000b\u00049mk\u0006\"\u0002/\u0005\u0001\u0004)\u0015a\u0002;sS\u001e<WM\u001d\u0005\u0006=\u0012\u0001\rAT\u0001\u0006]\u0016<\u0018\n\u001a")
public interface TriggerMapper {
    public static /* synthetic */ Function2 triggerMapper$(TriggerMapper $this) {
        return $this.triggerMapper();
    }

    default public <T extends Trigger> Function2<SqlRepositoryAdapter, FolderPersistence, RowMapper<T>> triggerMapper() {
        return (Function2 & Serializable)(sqlRepositoryAdapter, folderPersistence) -> (rs, x$3) -> {
            Trigger trigger;
            block3: {
                Trigger trigger2;
                block2: {
                    Trigger trigger3;
                    InputStream contentStream = rs.getBinaryStream(Schema.TRIGGERS$.MODULE$.CONTENT());
                    if (contentStream != null) {
                        trigger3 = (Trigger)ResourceManagement$.MODULE$.using((Closeable)contentStream, (Function1 & Serializable)is -> {
                            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                String json = (String)success.value();
                                return (Trigger)CiSerializerHelper$.MODULE$.deserialize(json, (Repository)sqlRepositoryAdapter);
                            }
                            if (try_ instanceof Failure) {
                                Failure failure = (Failure)try_;
                                Throwable ex = failure.exception();
                                throw new IllegalStateException("Failed to load trigger", ex);
                            }
                            throw new MatchError((Object)try_);
                        });
                    } else {
                        Type triggerType = Type.valueOf((String)rs.getString(Schema.TRIGGERS$.MODULE$.CI_TYPE()));
                        trigger3 = (Trigger)triggerType.getDescriptor().newInstance(null);
                    }
                    trigger = trigger3;
                    trigger.setCiUid(Predef$.MODULE$.int2Integer(rs.getInt(Schema.TRIGGERS$.MODULE$.CI_UID())));
                    trigger.setTitle(rs.getString(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()));
                    trigger.setDescription(rs.getString(Schema.TRIGGERS$.MODULE$.DESCRIPTION()));
                    trigger.setEnabled(Utils.RichIntAsBoolean$.MODULE$.asBoolean$extension(Utils$.MODULE$.RichIntAsBoolean(rs.getInt(Schema.TRIGGERS$.MODULE$.ENABLED()))));
                    FolderId folderId = new FolderId(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_ID()));
                    trigger.setFolderId(folderId.absolute());
                    trigger.setLastRunDate((Date)rs.getTimestamp(Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE()));
                    trigger.setLastRunStatus((TriggerExecutionStatus)Option$.MODULE$.apply((Object)rs.getString(Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS())).map((Function1 & Serializable)value -> TriggerExecutionStatus.valueOf((String)value.toUpperCase())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    String triggerId = Ids.formatWithFolderId((String)trigger.getFolderId(), (String)rs.getString(Schema.TRIGGERS$.MODULE$.ID()));
                    this.rewriteWithNewTriggerId(trigger, triggerId);
                    trigger2 = trigger;
                    if (!(trigger2 instanceof ReleaseTrigger)) break block2;
                    ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
                    releaseTrigger.setTemplate(TriggerMapper.getFullTemplateId$1(releaseTrigger.getTemplate(), sqlRepositoryAdapter));
                    releaseTrigger.setReleaseFolder(TriggerMapper.getFullFolderId$1(releaseTrigger.getReleaseFolder(), folderPersistence));
                    break block3;
                }
                if (!(trigger2 instanceof EventBasedTrigger)) break block3;
                EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
                CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerMapper.$anonfun$triggerMapper$6(x$4))).foreach((Function1 & Serializable)x0$1 -> {
                    TriggerMapper.$anonfun$triggerMapper$7(sqlRepositoryAdapter, x0$1);
                    return BoxedUnit.UNIT;
                });
                CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggerMapper.$anonfun$triggerMapper$8(x$5))).foreach((Function1 & Serializable)x0$2 -> {
                    TriggerMapper.$anonfun$triggerMapper$9(folderPersistence, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
            return trigger;
        };
    }

    public static /* synthetic */ RowMapper triggerIdRowMapper$(TriggerMapper $this) {
        return $this.triggerIdRowMapper();
    }

    default public RowMapper<String> triggerIdRowMapper() {
        return (rs, x$6) -> rs.getString(Schema.TRIGGERS$.MODULE$.ID());
    }

    private void rewriteWithNewTriggerId(Trigger trigger, String newId) {
        String oldId = trigger.getId();
        String oldIdPattern = String.format(".*%s(?=/|$)", oldId);
        CollectionConverters$.MODULE$.ListHasAsScala(CiHelper.getNestedCis((ConfigurationItem)trigger)).asScala().foreach((Function1 & Serializable)nestedCi -> {
            TriggerMapper.$anonfun$rewriteWithNewTriggerId$1(oldId, oldIdPattern, newId, nestedCi);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)trigger)).asScala().foreach((Function1 & Serializable)referencedCi -> {
            TriggerMapper.$anonfun$rewriteWithNewTriggerId$2(oldId, oldIdPattern, newId, referencedCi);
            return BoxedUnit.UNIT;
        });
    }

    private static String getFullTemplateId$1(String templateId, SqlRepositoryAdapter sqlRepositoryAdapter$1) {
        if (templateId != null) {
            String partialId = Ids.getName((String)templateId);
            Option maybeTemplateFolderId = sqlRepositoryAdapter$1.releasePersistence().findFolderIdByReleaseId(partialId);
            Option option = maybeTemplateFolderId;
            if (option instanceof Some) {
                Some some = (Some)option;
                String folderId = (String)some.value();
                return Ids.formatWithFolderId((String)folderId, (String)partialId);
            }
            if (None$.MODULE$.equals(option)) {
                return templateId;
            }
            throw new MatchError((Object)option);
        }
        return templateId;
    }

    private static String getFullFolderId$1(String folderId, FolderPersistence folderPersistence$1) {
        if (folderId != null) {
            String partialId = Ids.getName((String)folderId);
            return FolderRow.NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(folderPersistence$1.findById(partialId, 0))).getId();
        }
        return folderId;
    }

    public static /* synthetic */ boolean $anonfun$triggerMapper$6(MappedProperty x$4) {
        String string = x$4.targetProperty();
        String string2 = "templateId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$triggerMapper$7(SqlRepositoryAdapter sqlRepositoryAdapter$1, MappedProperty x0$1) {
        MappedProperty mappedProperty = x0$1;
        if (mappedProperty instanceof MappedProperty.StringValue) {
            MappedProperty.StringValue stringValue = (MappedProperty.StringValue)mappedProperty;
            stringValue.setValue(TriggerMapper.getFullTemplateId$1(stringValue.value(), sqlRepositoryAdapter$1));
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$triggerMapper$8(MappedProperty x$5) {
        String string = x$5.targetProperty();
        String string2 = "releaseFolderId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$triggerMapper$9(FolderPersistence folderPersistence$1, MappedProperty x0$2) {
        MappedProperty mappedProperty = x0$2;
        if (mappedProperty instanceof MappedProperty.StringValue) {
            MappedProperty.StringValue stringValue = (MappedProperty.StringValue)mappedProperty;
            stringValue.setValue(TriggerMapper.getFullFolderId$1(stringValue.value(), folderPersistence$1));
            return;
        }
    }

    public static /* synthetic */ void $anonfun$rewriteWithNewTriggerId$1(String oldId$1, String oldIdPattern$1, String newId$1, ConfigurationItem nestedCi) {
        if (nestedCi.getId() != null && nestedCi.getId().contains(oldId$1)) {
            String rewrittenId = nestedCi.getId().replaceFirst(oldIdPattern$1, newId$1);
            nestedCi.setId(rewrittenId);
            return;
        }
    }

    public static /* synthetic */ void $anonfun$rewriteWithNewTriggerId$2(String oldId$1, String oldIdPattern$1, String newId$1, ConfigurationItem referencedCi) {
        if (referencedCi.getId() != null && referencedCi.getId().contains(oldId$1)) {
            String rewrittenId = referencedCi.getId().replaceFirst(oldIdPattern$1, newId$1);
            referencedCi.setId(rewrittenId);
            return;
        }
    }

    public static void $init$(TriggerMapper $this) {
    }
}

