/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.event_based;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.xlplatform.webhooks.domain.HttpRequestEvent;
import com.xebialabs.xlplatform.webhooks.events.domain.Event;
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventFilter;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005e4\u0001\u0002C\u0005\u0011\u0002\u0007\u0005A#\u001c\u0005\u00067\u0001!\t\u0001\b\u0005\u0006A\u0001!\t\"\t\u0005\u0006A\u0001!\t\"\u0012\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u0006=\u0002!Ia\u0018\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006Q\u0002!I!\u001b\u0002\u000f\u000bZ,g\u000e\u001e$jYR,'/\u001b8h\u0015\tQ1\"A\u0006fm\u0016tGo\u00182bg\u0016$'B\u0001\u0007\u000e\u0003!!(/[4hKJ\u001c(B\u0001\b\u0010\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0011#\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002%\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005i\u0002C\u0001\f\u001f\u0013\tyrC\u0001\u0003V]&$\u0018\u0001\u00033p\r&dG/\u001a:\u0015\t\t*3&\u000f\t\u0003-\rJ!\u0001J\f\u0003\u000f\t{w\u000e\\3b]\")aE\u0001a\u0001O\u00059AO]5hO\u0016\u0014\bC\u0001\u0015*\u001b\u0005I\u0011B\u0001\u0016\n\u0005E)e/\u001a8u\u0005\u0006\u001cX\r\u001a+sS\u001e<WM\u001d\u0005\u0006Y\t\u0001\r!L\u0001\u0006KZ,g\u000e\u001e\t\u0003]]j\u0011a\f\u0006\u0003aE\na\u0001Z8nC&t'B\u0001\u001a4\u0003\u0019)g/\u001a8ug*\u0011A'N\u0001\to\u0016\u0014\u0007n\\8lg*\u0011agD\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017B\u0001\u001d0\u0005\u0015)e/\u001a8u\u0011\u0015Q$\u00011\u0001<\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014aB2p]R,\u0007\u0010\u001e\u0006\u0003\u0001\u0006\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011k$AE!qa2L7-\u0019;j_:\u001cuN\u001c;fqR$2A\t$N\u0011\u001513\u00011\u0001H!\tA5*D\u0001J\u0015\tQ5\"\u0001\teKBdw._7f]R|&-Y:fI&\u0011A*\u0013\u0002\u0015'R\fG/^:XK\nDwn\\6Ue&<w-\u001a:\t\u000b1\u001a\u0001\u0019A\u0017\u00025%\u001c\u0018\t\u001d9mS\u000e\fG/[8o)&$H.Z'bi\u000eD\u0017N\\4\u0015\u0007\t\u0002\u0016\u000bC\u0003'\t\u0001\u0007q\tC\u0003S\t\u0001\u00071+A\u0004baBt\u0015-\\3\u0011\u0005Q[fBA+Z!\t1v#D\u0001X\u0015\tA6#\u0001\u0004=e>|GOP\u0005\u00035^\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!lF\u0001\u001bSN$U\r\u001d7ps6,g\u000e^*uCR,8/T1uG\"Lgn\u001a\u000b\u0004E\u0001\f\u0007\"\u0002\u0014\u0006\u0001\u00049\u0005\"\u00022\u0006\u0001\u0004\u0019\u0016AB:uCR,8/\u0001\u000ejg\u0016sg/\u001b:p]6,g\u000e\u001e+ji2,W*\u0019;dQ&tw\rF\u0002#K\u001aDQA\n\u0004A\u0002\u001dCQa\u001a\u0004A\u0002M\u000b1!\u001a8w\u0003QI7/\u00119q-\u0016\u00148/[8o\u001b\u0006$8\r[5oOR\u0019!E[6\t\u000b\u0019:\u0001\u0019A$\t\u000b1<\u0001\u0019A*\u0002\u0015\u0005\u0004\bO^3sg&|gNE\u0002oaF4Aa\u001c\u0001\u0001[\naAH]3gS:,W.\u001a8u}A\u0011\u0001\u0006\u0001\t\u0003e^l\u0011a\u001d\u0006\u0003iV\fQa\u001d7gi)T\u0011A^\u0001\tOJL'P\u001f7fI&\u0011\u0001p\u001d\u0002\b\u0019><w-\u001b8h\u0001")
public interface EventFiltering {
    public static /* synthetic */ boolean doFilter$(EventFiltering $this, EventBasedTrigger trigger, Event event, ApplicationContext applicationContext) {
        return $this.doFilter(trigger, event, applicationContext);
    }

    default public boolean doFilter(EventBasedTrigger trigger, Event event, ApplicationContext applicationContext) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)trigger.eventFilter()).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            ((Logging)this).logger().info((Function0 & Serializable)() -> "Executing trigger '" + trigger.getTitle() + "' on new event");
            return true;
        }, (Function1 & Serializable)eventFilter -> BoxesRunTime.boxToBoolean((boolean)EventFiltering.$anonfun$doFilter$3(this, applicationContext, event, trigger, eventFilter))));
    }

    public static /* synthetic */ boolean doFilter$(EventFiltering $this, StatusWebhookTrigger trigger, Event event) {
        return $this.doFilter(trigger, event);
    }

    default public boolean doFilter(StatusWebhookTrigger trigger, Event event) {
        JsonNode eventContentNode = new ObjectMapper().readTree(((HttpRequestEvent)event).content());
        String appName = eventContentNode.get("applicationName").asText();
        String env = eventContentNode.get("state").get("destination").asText();
        String appversion = eventContentNode.get("state").get("versionTag").asText();
        String status = eventContentNode.get("state").get("deploymentStatus").asText();
        if (!(this.isApplicationTitleMatching(trigger, appName) && this.isDeploymentStatusMatching(trigger, status) && this.isEnvironmentTitleMatching(trigger, env) && this.isAppVersionMatching(trigger, appversion))) {
            ((Logging)this).logger().debug((Function0 & Serializable)() -> "Filter not satisfied on trigger '" + trigger.getTitle() + "' for application '" + appName + "', environment '" + env + "', version '" + appversion + "' and status '" + status + "'");
            return false;
        }
        ((Logging)this).logger().info((Function0 & Serializable)() -> "Executing trigger '" + trigger.getTitle() + "' on new event for application '" + appName + "', environment '" + env + "', version '" + appversion + "' and status '" + status + "'");
        return true;
    }

    private boolean isApplicationTitleMatching(StatusWebhookTrigger trigger, String appName) {
        String string = trigger.getApplicationTitle();
        String string2 = appName;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isDeploymentStatusMatching(StatusWebhookTrigger trigger, String status) {
        return trigger.getDeploymentStatuses().contains((Object)status.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEnvironmentTitleMatching(StatusWebhookTrigger trigger, String env) {
        if (trigger.getEnvironmentTitle().isEmpty()) return true;
        String string = trigger.getEnvironmentTitle();
        String string2 = env;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAppVersionMatching(StatusWebhookTrigger trigger, String appversion) {
        if (trigger.getAppVersion().isEmpty()) return true;
        String string = trigger.getAppVersion();
        String string2 = appversion;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trigger.getAppVersion();
        String string4 = "*";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static /* synthetic */ boolean $anonfun$doFilter$3(EventFiltering $this, ApplicationContext applicationContext$1, Event event$1, EventBasedTrigger trigger$1, EventFilter eventFilter) {
        boolean bl;
        applicationContext$1.getAutowireCapableBeanFactory().autowireBean((Object)eventFilter);
        boolean bl2 = false;
        Success success = null;
        Try<Object> try_ = eventFilter.matches(event$1);
        if (try_ instanceof Success) {
            bl2 = true;
            success = (Success)try_;
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (!bl3) {
                ((Logging)$this).logger().debug((Function0 & Serializable)() -> "Filter not satisfied on trigger '" + trigger$1.getTitle() + "' [" + trigger$1.getId() + "]");
                return false;
            }
        }
        if (bl2 && (bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            ((Logging)$this).logger().debug((Function0 & Serializable)() -> "Filter satisfied on trigger '" + trigger$1.getTitle() + "' [" + trigger$1.getId() + "]");
            ((Logging)$this).logger().info((Function0 & Serializable)() -> "Executing trigger '" + trigger$1.getTitle() + "' on new matched event");
            return true;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            ((Logging)$this).logger().warn((Function0 & Serializable)() -> "Error evaluating filter of trigger '" + trigger$1.getTitle() + "' [" + trigger$1.getId() + "]");
            throw exception;
        }
        throw new MatchError(try_);
    }

    public static void $init$(EventFiltering $this) {
    }
}

