/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.deployment_based.validators;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.triggers.TriggerValidator;
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger;
import scala.;
import scala.$less$colon$less$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00194AAB\u0004\u0001)!)\u0011\u0007\u0001C\u0001e!)Q\u0007\u0001C!m!)A\t\u0001C\u0005\u000b\")A\n\u0001C\u0005\u001b\")!\r\u0001C\u0005G\ni2\u000b^1ukN<VM\u00195p_.$&/[4hKJ4\u0016\r\\5eCR|'O\u0003\u0002\t\u0013\u0005Qa/\u00197jI\u0006$xN]:\u000b\u0005)Y\u0011\u0001\u00053fa2|\u00170\\3oi~\u0013\u0017m]3e\u0015\taQ\"\u0001\u0005ue&<w-\u001a:t\u0015\tqq\"A\u0005yYJ,G.Z1tK*\u0011\u0001#E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AE\u0001\u0004G>l7\u0001A\n\u0005\u0001UiR\u0006\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005!A.\u00198h\u0015\u0005Q\u0012\u0001\u00026bm\u0006L!\u0001H\f\u0003\r=\u0013'.Z2u!\rqr%K\u0007\u0002?)\u0011\u0001%I\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\u0012$\u0003\r\t\u0007/\u001b\u0006\u0003I\u0015\na\u0001\u001d7vO&t'B\u0001\u0014\u0010\u0003!!W\r\u001d7ps&$\u0018B\u0001\u0015 \u0005%1\u0016\r\\5eCR|'\u000f\u0005\u0002+W5\t\u0011\"\u0003\u0002-\u0013\t!2\u000b^1ukN<VM\u00195p_.$&/[4hKJ\u0004\"AL\u0018\u000e\u0003-I!\u0001M\u0006\u0003!Q\u0013\u0018nZ4feZ\u000bG.\u001b3bi>\u0014\u0018A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\b\u0003!1\u0018\r\\5eCR,GcA\u001c>\u007fA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t!QK\\5u\u0011\u0015q$\u00011\u0001*\u0003\u001d!(/[4hKJDQ\u0001\u0011\u0002A\u0002\u0005\u000bqaY8oi\u0016DH\u000f\u0005\u0002\u001f\u0005&\u00111i\b\u0002\u0012-\u0006d\u0017\u000eZ1uS>t7i\u001c8uKb$\u0018AJ2iK\u000e\\GK]5hO\u0016\u0014hi\u001c7eKJ\fe\u000eZ*pkJ\u001cWMR8mI\u0016\u0014X*\u0019;dQR\u0019qGR&\t\u000b\u001d\u001b\u0001\u0019\u0001%\u0002\u001f\u0015DH/\u001a8eK\u0012\u001cuN\u001c;fqR\u0004\"AH%\n\u0005){\"!G#yi\u0016tG-\u001a3WC2LG-\u0019;j_:\u001cuN\u001c;fqRDQAP\u0002A\u0002%\nAd\u00195fG.4\u0015\u000e\u001c;fe&twMR5fY\u0012\u001c\bK]3tK:\u001cW\rF\u00038\u001d>\u0003V\fC\u0003H\t\u0001\u0007\u0001\nC\u0003?\t\u0001\u0007\u0011\u0006C\u0003R\t\u0001\u0007!+\u0001\u0005baB$\u0016\u000e\u001e7f!\t\u0019&L\u0004\u0002U1B\u0011Q+O\u0007\u0002-*\u0011qkE\u0001\u0007yI|w\u000e\u001e \n\u0005eK\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!W\u001d\t\u000by#\u0001\u0019A0\u0002%\u0011,\u0007\u000f\\8z[\u0016tGo\u0015;biV\u001cXm\u001d\t\u0004'\u0002\u0014\u0016BA1]\u0005\r\u0019V\r^\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0016sG\r]8j]R$2a\u000e3f\u0011\u0015qT\u00011\u0001*\u0011\u00159U\u00011\u0001I\u0001")
public class StatusWebhookTriggerValidator
implements Validator<StatusWebhookTrigger>,
TriggerValidator {
    @Override
    public void checkTemplatePresence(ExtendedValidationContext extendedContext, Trigger trigger, String templateId) {
        TriggerValidator.checkTemplatePresence$(this, extendedContext, trigger, templateId);
    }

    @Override
    public void checkTemplateFolderAndTriggerFolderMatch(ExtendedValidationContext extendedContext, Trigger trigger, String templateId) {
        TriggerValidator.checkTemplateFolderAndTriggerFolderMatch$(this, extendedContext, trigger, templateId);
    }

    @Override
    public void checkReleaseTitlePresence(ExtendedValidationContext extendedContext, Trigger trigger, String releaseTitle) {
        TriggerValidator.checkReleaseTitlePresence$(this, extendedContext, trigger, releaseTitle);
    }

    @Override
    public void checkMalformedVariableNamesInMappings(Trigger trigger, ExtendedValidationContext extendedContext) {
        TriggerValidator.checkMalformedVariableNamesInMappings$(this, trigger, extendedContext);
    }

    public void validate(StatusWebhookTrigger trigger, ValidationContext context) {
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        String templateId = (String)trigger.getTemplateId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String releaseTitle = (String)trigger.getReleaseTitle().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Set<String> deploymentStatuses = trigger.getDeploymentStatuses();
        String appTitle = trigger.getApplicationTitle();
        this.validateEndpoint(trigger, extendedContext);
        this.checkTemplatePresence(extendedContext, trigger, templateId);
        this.checkTemplateFolderAndTriggerFolderMatch(extendedContext, trigger, templateId);
        this.checkTriggerFolderAndSourceFolderMatch(extendedContext, trigger);
        this.checkReleaseTitlePresence(extendedContext, trigger, releaseTitle);
        this.checkFilteringFieldsPresence(extendedContext, trigger, appTitle, deploymentStatuses);
        this.checkMalformedVariableNamesInMappings(trigger, extendedContext);
    }

    private void checkTriggerFolderAndSourceFolderMatch(ExtendedValidationContext extendedContext, StatusWebhookTrigger trigger) {
        if (trigger.getEndpoint() != null && trigger.getEndpoint().getEventSource() != null) {
            String eventFolderId = (String)trigger.getEndpoint().getEventSource().getProperty("folderId");
            String endpointFolderId = trigger.getEndpoint().getFolderId();
            if (!(Strings.isNullOrEmpty((String)endpointFolderId) || Strings.isNullOrEmpty((String)eventFolderId) || eventFolderId.equals(endpointFolderId))) {
                extendedContext.error((ConfigurationItem)trigger, "eventSource", "Event source folder id does not match endpoint folder id", new Object[0]);
            }
            if (!(Strings.isNullOrEmpty((String)trigger.getFolderId()) || Strings.isNullOrEmpty((String)endpointFolderId) || Strings.isNullOrEmpty((String)eventFolderId) || trigger.getFolderId().contains(Ids.getName((String)eventFolderId)))) {
                extendedContext.error((ConfigurationItem)trigger, "eventSource", "Couldn't set eventSource that doesn't belong to the folder['" + trigger.getFolderId() + "']", new Object[0]);
                return;
            }
            return;
        }
    }

    private void checkFilteringFieldsPresence(ExtendedValidationContext extendedContext, StatusWebhookTrigger trigger, String appTitle, Set<String> deploymentStatuses) {
        if (Strings.isNullOrEmpty((String)appTitle)) {
            extendedContext.error((ConfigurationItem)trigger, "applicationTitle", "Application title is required", new Object[0]);
        }
        if (deploymentStatuses == null || deploymentStatuses.isEmpty()) {
            extendedContext.error((ConfigurationItem)trigger, "deploymentStatuses", "Trigger does not have associated statuses", new Object[0]);
            return;
        }
    }

    private void validateEndpoint(StatusWebhookTrigger trigger, ExtendedValidationContext extendedContext) {
        if (trigger.getEndpoint() == null) {
            extendedContext.error((ConfigurationItem)trigger, "endpoint", "Trigger endpoint is required", new Object[0]);
            return;
        }
        if (trigger.getEndpoint().getEventSource() == null) {
            extendedContext.error((ConfigurationItem)trigger, "endpoint.eventSource", "Trigger endpoint event source is required", new Object[0]);
            return;
        }
    }

    public StatusWebhookTriggerValidator() {
        TriggerValidator.$init$(this);
    }
}

