/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.validators;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.triggers.scheduled.validators.ScheduledTriggerValidator$;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.utils.QuartzUtils;
import com.xebialabs.xlrelease.utils.QuartzUtils$;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.quartz.CronExpression;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015r!B\u0006\r\u0011\u0003Ib!B\u000e\r\u0011\u0003a\u0002\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007s\u0005\u0001\u000b\u0011B\u001a\t\u0011i\n\u0001R1A\u0005\nm2Aa\u0007\u0007\u0001\u0005\")qF\u0002C\u0001+\")qK\u0002C!1\")1M\u0002C\u0005I\")!P\u0002C\u0001w\u0006I2k\u00195fIVdW\r\u001a+sS\u001e<WM\u001d,bY&$\u0017\r^8s\u0015\tia\"\u0001\u0006wC2LG-\u0019;peNT!a\u0004\t\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$'BA\t\u0013\u0003!!(/[4hKJ\u001c(BA\n\u0015\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001A\u0011!$A\u0007\u0002\u0019\tI2k\u00195fIVdW\r\u001a+sS\u001e<WM\u001d,bY&$\u0017\r^8s'\r\tQ$\n\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u0019y%M[3diB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005)Z\u0013!\u00029fW.|'B\u0001\u0017\u0013\u0003\u001d\u0019X\u000f\u001d9peRL!AL\u0014\u0003)M\u001b\u0017\r\\1TaJLgnZ!xCJ,')Z1o\u0003\u0019a\u0014N\\5u}Q\t\u0011$\u0001\u000fO+6\u0013UIU0P\r~Ke\nV#S-\u0006c5k\u0018+P?\u000eCUiQ&\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u00121!\u00138u\u0003uqU+\u0014\"F%~{eiX%O)\u0016\u0013f+\u0011'T?R{ul\u0011%F\u0007.\u0003\u0013\u0001F2p]\u001aLw-\u001e:bi&|gnU3sm&\u001cW-F\u0001=!\ti\u0004)D\u0001?\u0015\ty$#A\u0004tKJ4\u0018nY3\n\u0005\u0005s$\u0001F\"p]\u001aLw-\u001e:bi&|gnU3sm&\u001cWmE\u0002\u0007;\r\u00032\u0001R'P\u001b\u0005)%B\u0001$H\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0011&\u000b1!\u00199j\u0015\tQ5*\u0001\u0004qYV<\u0017N\u001c\u0006\u0003\u0019R\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u001d\u0016\u0013\u0011BV1mS\u0012\fGo\u001c:\u0011\u0005A\u001bV\"A)\u000b\u0005I\u0013\u0012A\u00023p[\u0006Lg.\u0003\u0002U#\n\u00012k\u00195fIVdW\r\u001a+sS\u001e<WM\u001d\u000b\u0002-B\u0011!DB\u0001\tm\u0006d\u0017\u000eZ1uKR\u0019\u0011\f\u00180\u0011\u0005QR\u0016BA.6\u0005\u0011)f.\u001b;\t\u000buC\u0001\u0019A(\u0002\u000fQ\u0014\u0018nZ4fe\")q\f\u0003a\u0001A\u000691m\u001c8uKb$\bC\u0001#b\u0013\t\u0011WIA\tWC2LG-\u0019;j_:\u001cuN\u001c;fqR\fAB^1mS\u0012\fG/Z\"s_:$R!W3siVDQAZ\u0005A\u0002\u001d\f!\"\u001a=qe\u0016\u001c8/[8o!\tAwN\u0004\u0002j[B\u0011!.N\u0007\u0002W*\u0011A\u000eG\u0001\u0007yI|w\u000e\u001e \n\u00059,\u0014A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\u001b\t\u000bML\u0001\u0019A\u001a\u0002\u000b1LW.\u001b;\t\u000buK\u0001\u0019A(\t\u000bYL\u0001\u0019A<\u0002\u001f\u0015DH/\u001a8eK\u0012\u001cuN\u001c;fqR\u0004\"\u0001\u0012=\n\u0005e,%!G#yi\u0016tG-\u001a3WC2LG-\u0019;j_:\u001cuN\u001c;fqR\f\u0001%\u0019:f\u001d\u0016DH/\u00138uKJ4\u0018\r\\:TQ>\u0014H/\u001a:UQ\u0006tG*[7jiR1Ap`A\n\u0003G\u0001\"\u0001N?\n\u0005y,$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003Q\u0001\u0019AA\u0002\u00039\u0019'o\u001c8FqB\u0014Xm]:j_:\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004rk\u0006\u0014HO\u001f\u0006\u0003\u0003\u001b\t1a\u001c:h\u0013\u0011\t\t\"a\u0002\u0003\u001d\r\u0013xN\\#yaJ,7o]5p]\"9\u0011Q\u0003\u0006A\u0002\u0005]\u0011!C:uCJ$H+[7f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fC\u0005!Q\u000f^5m\u0013\u0011\t\t#a\u0007\u0003\t\u0011\u000bG/\u001a\u0005\u0006g*\u0001\ra\r")
public class ScheduledTriggerValidator
implements Validator<ScheduledTrigger> {
    public static int NUMBER_OF_INTERVALS_TO_CHECK() {
        return ScheduledTriggerValidator$.MODULE$.NUMBER_OF_INTERVALS_TO_CHECK();
    }

    public static void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ScheduledTriggerValidator$.MODULE$.setApplicationContext(applicationContext);
    }

    public static ApplicationContext getApplicationContext() {
        return ScheduledTriggerValidator$.MODULE$.getApplicationContext();
    }

    public static void applicationContext_$eq(ApplicationContext x$1) {
        ScheduledTriggerValidator$.MODULE$.applicationContext_$eq(x$1);
    }

    public static ApplicationContext applicationContext() {
        return ScheduledTriggerValidator$.MODULE$.applicationContext();
    }

    public static <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScheduledTriggerValidator$.MODULE$.springBeans(evidence$3);
    }

    public static <T> T springBean(String name, ClassTag<T> evidence$2) {
        return ScheduledTriggerValidator$.MODULE$.springBean(name, evidence$2);
    }

    public static <T> T springBean(ClassTag<T> evidence$1) {
        return ScheduledTriggerValidator$.MODULE$.springBean(evidence$1);
    }

    public void validate(ScheduledTrigger trigger, ValidationContext context) {
        FeatureSettings limits = ScheduledTriggerValidator$.MODULE$.com$xebialabs$xlrelease$triggers$scheduled$validators$ScheduledTriggerValidator$$configurationService().getFeatureSettings(Limits$.MODULE$.TYPE_LIMITS());
        int minTriggerInterval = BoxesRunTime.unboxToInt((Object)limits.getProperty(Limits$.MODULE$.MIN_TRIGGER_INTERVAL()));
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limits.getProperty(Limits$.MODULE$.ENABLED()));
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        PollType pollType = trigger.getPollType();
        if (PollType.REPEAT.equals(pollType)) {
            int period = NumberUtils.toInt((String)trigger.getPeriodicity(), (int)0);
            if (period <= 0) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", "Trigger has wrong periodicity '" + trigger.getPeriodicity() + "'", new Object[0]);
                return;
            }
            if (limitsEnabled && period < minTriggerInterval) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", "Trigger must not fire more frequently than once per " + minTriggerInterval + " seconds", new Object[0]);
                return;
            }
            return;
        }
        if (PollType.CRON.equals(pollType)) {
            String cron = trigger.getPeriodicity();
            String errorMsg = "Trigger has wrong cron expression '" + cron + "'";
            if (StringUtils.isBlank((CharSequence)cron)) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                return;
            }
            if (!CronExpression.isValidExpression((String)QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(cron)))) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                return;
            }
            if (limitsEnabled) {
                this.validateCron(cron, minTriggerInterval, trigger, extendedContext);
                return;
            }
            return;
        }
        throw new MatchError((Object)pollType);
    }

    private void validateCron(String expression, int limit, ScheduledTrigger trigger, ExtendedValidationContext extendedContext) {
        DateTime today;
        CronExpression cronExpression = new CronExpression(QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(expression)));
        boolean intervalsLongerThanLimit = this.areNextIntervalsShorterThanLimit(cronExpression, (today = new DateTime().withTimeAtStartOfDay()).toDate(), limit);
        if (!intervalsLongerThanLimit) {
            extendedContext.error((ConfigurationItem)trigger, "periodicity", "Trigger must not fire more frequently than once per " + limit + " seconds", new Object[0]);
            return;
        }
    }

    public boolean areNextIntervalsShorterThanLimit(CronExpression cronExpression, Date startTime, int limit) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef reference = ObjectRef.create((Object)cronExpression.getNextValidTimeAfter(startTime));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), ScheduledTriggerValidator$.MODULE$.NUMBER_OF_INTERVALS_TO_CHECK()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                int n = x$1;
                Date nextTime = cronExpression.getNextValidTimeAfter((Date)reference$1.elem);
                int interval = (int)((nextTime.getTime() - ((Date)reference$1.elem).getTime()) / 1000L);
                if (interval < limit) {
                    throw new RuntimeException();
                }
                reference$1.elem = nextTime;
            });
        }).isSuccess();
    }
}

