package com.xebialabs.xlrelease.triggers.event_based

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.annotations.TypeBounds
import com.xebialabs.xlplatform.webhooks.events.domain.EventSource
import com.xebialabs.xlrelease.triggers.AbstractEventTrigger
import com.xebialabs.xlrelease.triggers.validators.EventBasedTriggerRule

import scala.beans.BeanProperty

@EventBasedTriggerRule
@Metadata(virtual = false, label = "Webhook event trigger")
class EventBasedTrigger
  extends AbstractEventTrigger {
  @BeanProperty
  @Property(label = "Event source", description = "The HTTP endpoint or the typed event source on which the trigger listens")
  var eventSource: EventSource = _

  @TypeBounds(focusType = "events.Event", focusProperty = "eventSource.outputEventType", topType = "events.Event")
  @BeanProperty
  @Property(label = "Event type", description = "The type of the event to listen for")
  var eventType: String = _

  @BeanProperty
  @Property(label = "Event filter", required = false,
    description = "Filter expression to conditionally execute the trigger depending on the data inside the event")
  var eventFilter: EventFilter = _

}
