package com.xebialabs.xlrelease.triggers.config

import com.xebialabs.deployit.security.{PermissionEnforcer, RoleService}
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.repository.TriggerRepository
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence
import com.xebialabs.xlrelease.spring.config.{SqlConfiguration, SqlPersistenceConfiguration, SqlRepositoriesConfiguration}
import com.xebialabs.xlrelease.triggers.management.repository.TriggerManagementRepository
import com.xebialabs.xlrelease.triggers.repository.SqlTriggerRepository
import com.xebialabs.xlrelease.triggers.repository.persistence.{TriggerPersistence, TriggerPersistenceInterceptor, TriggerTemplatePersistenceInterceptor}
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class TriggerConfiguration(sqlConfiguration: SqlConfiguration,
                           sqlRepositories: SqlRepositoriesConfiguration,
                           sqlPersistenceConfiguration: SqlPersistenceConfiguration,
                           permissionEnforcer: PermissionEnforcer,
                           limitEnforcer: LimitEnforcer,
                           roleService: RoleService) {

  @Bean
  def triggerConfigurationReferencePersistence(): TriggerConfigurationReferencePersistence = new TriggerConfigurationReferencePersistence(
    sqlPersistenceConfiguration.folderPersistence(),
    sqlConfiguration.xlrRepositoryJdbcTemplate(),
    sqlConfiguration.xlrRepositorySqlDialect()
  )

  @Bean
  def triggerPersistence(): TriggerPersistence = {
    new TriggerPersistence(
      sqlPersistenceConfiguration.folderPersistence(),
      sqlPersistenceConfiguration.sqlRepositoryAdapter(),
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect()
    )
  }

  @Bean
  def triggerRepository(): TriggerRepository = {
    val repository = new SqlTriggerRepository(triggerPersistence(), sqlConfiguration.ciIdService())
    repository.registerPersistenceInterceptor(triggerPersistenceInterceptor())
    repository
  }

  @Bean
  def triggerManagementRepository(): TriggerManagementRepository = {
    new TriggerManagementRepository(
      permissionEnforcer,
      roleService,
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def triggerPersistenceInterceptor(): TriggerPersistenceInterceptor = {
    new TriggerPersistenceInterceptor(
      triggerPersistence(),
      sqlPersistenceConfiguration.releasePersistence(),
      triggerConfigurationReferencePersistence(),
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect(),
      limitEnforcer
    )
  }

  @Bean
  def triggerTemplatePersistenceInterceptor(): TriggerTemplatePersistenceInterceptor = {
    val interceptor = new TriggerTemplatePersistenceInterceptor(
      sqlPersistenceConfiguration.releasePersistence(),
      triggerPersistence(),
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect()
    )
    sqlRepositories.releaseRepository().registerPersistenceInterceptor(interceptor)
    interceptor
  }

}
