/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.api.internal.BaseActivityLogsResource;
import com.xebialabs.xlrelease.service.BaseActivityLogsService;
import com.xebialabs.xlrelease.triggers.activity.TriggerActivityLogsService;
import com.xebialabs.xlrelease.triggers.security.TriggerPermissionChecker;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/activity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TriggerActivityLogsResource
extends BaseActivityLogsResource {
    private final TriggerPermissionChecker triggerPermissionChecker;

    @Autowired
    public TriggerActivityLogsResource(TriggerActivityLogsService triggerActivityLogsService, UserViewConverter userViewConverter, TriggerPermissionChecker triggerPermissionChecker) {
        super((BaseActivityLogsService)triggerActivityLogsService, userViewConverter);
        this.triggerPermissionChecker = triggerPermissionChecker;
    }

    @POST
    @Path(value="/{triggerId:.*Trigger[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchTriggerLogs(@PathParam(value="triggerId") String triggerId, LogsFilters filters) {
        this.triggerPermissionChecker.checkViewTrigger(triggerId);
        return this.searchLogs(triggerId, filters);
    }
}

