package com.xebialabs.xlrelease.webhooks.task

import com.xebialabs.xlrelease.domain.{CustomScriptTask, Task}
import com.xebialabs.xlrelease.webhooks.endpoint.WebhookEndpoint
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import grizzled.slf4j.Logging

import scala.util.{Failure, Success, Try}

trait ReactiveTaskSubscriber extends Logging {
  def subscriberRegistry: SubscriberRegistry

  def register(task: Task): Unit = {
    Try {
      unregister(task)
      val pythonScript = task.asInstanceOf[CustomScriptTask].getPythonScript
      Option(pythonScript.getProperty(ENDPOINT_PROPERTY).asInstanceOf[WebhookEndpoint]) match {
        case Some(endpoint) =>
          subscriberRegistry.subscribe(endpoint.getId, ReactiveTaskConsumer(task.getId))
        case None => logger.debug(s"No endpoint to register subscriber for reactive task '${task.getTitle}'[${task.getId}]")
      }
    } match {
      case Failure(ex) => logger.error(s"Unable to register subscriber for reactive task '${task.getTitle}'[${task.getId}]", ex)
      case Success(_) => logger.debug(s"Registered subscriber for reactive task '${task.getTitle}'[${task.getId}]")
    }
  }

  def unregister(task: Task): Unit = {
    subscriberRegistry.remove(ReactiveTaskConsumer(task.getId).consumerId)
  }

  def isReactiveTask(task: Task): Boolean = task match {
    case cst: CustomScriptTask =>
      cst.getTaskType.isSubTypeOf(REACTIVE_TASK_TYPE) || isImplicitReactive(cst.getTaskType)
    case _ => false
  }

}