package com.xebialabs.xlplatform.webhooks.queue.configuration

import com.xebialabs.deployit.security.SecretKeyHolder
import grizzled.slf4j.Logging
import org.apache.qpid.jms.JmsConnectionFactory
import org.springframework.jms.config.DefaultJmsListenerContainerFactory
import org.springframework.jms.core.JmsTemplate

import javax.jms.ConnectionFactory

// TODO: remove logging
// TODO: deal with profiles in platform...
class StandaloneQueueConfiguration() extends AbstractQueueConfiguration with Logging {

  lazy val activeMq: javax.jms.ConnectionFactory = {
    logger.trace("activeMq() config")
    // TODO: fixme!
    val config = JmsQueueConfig.newInstance("xl-release.conf", SecretKeyHolder.get)
    new JmsConnectionFactory(config.username, config.password, config.url) //5672 //61616
  }

  override def jmsConnectionFactory: ConnectionFactory = activeMq

  override def jmsListenerContainerFactory: DefaultJmsListenerContainerFactory = {
    logger.trace("jmsListenerContainerFactory() config")
    val factory = new DefaultJmsListenerContainerFactory
    factory.setConnectionFactory(activeMq)
    factory
  }

  def jmsTemplate: JmsTemplate = {
    new JmsTemplate(activeMq)
  }

}
