package com.xebialabs.xlrelease.webhooks.task

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator.SERVER_URL
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.repository.TaskRepository
import com.xebialabs.xlrelease.scheduler.workers.CustomScriptTaskWorker
import com.xebialabs.xlrelease.script.{FailedEventResult, MatchedEventResult, UnmatchedEventResult}
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions
import com.xebialabs.xlrelease.webhooks.consumers.BaseConsumerHandler
import com.xebialabs.xlrelease.webhooks.task.script.ReactiveEventFilter
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Arrays.asList
import scala.util.Try

@Component
class ReactiveTaskConsumerHandler @Autowired()(taskRepository: TaskRepository,
                                               decoratorService: InternalMetadataDecoratorService,
                                               eventFilter: ReactiveEventFilter,
                                               customScriptTaskWorker: CustomScriptTaskWorker)
  extends BaseConsumerHandler[ReactiveTaskConsumer] with Logging {

  override def consumerConfigType: Type = Type.valueOf(classOf[ReactiveTaskConsumer])

  override def filter(config: ReactiveTaskConsumer, event: Event): Boolean = {
    Try {
      val task = taskRepository.findById[CustomScriptTask](config.taskId, ResolveOptions.WITH_DECORATORS)
      decoratorService.decorate(task.getRelease, asList(GLOBAL_AND_FOLDER_VARIABLES, SERVER_URL))

      val result = eventFilter.matches(task, event)
      result.toCustomScriptTaskResult.foreach(r => customScriptTaskWorker.handleCustomScriptTaskResult(r))
      result match {
        case MatchedEventResult(_, _, _, _, _, _) => true
        case UnmatchedEventResult(_, _, _, _, _, _) => false
        case FailedEventResult(_, _, _, _, _, _) => false
      }
    }.recover {
      case e =>
        logger.error("Filter caused exception, assuming false", e)
        false
    }.get
  }

  override def consumeEvent(config: ReactiveTaskConsumer, event: Event): Boolean = {
    // The filter has already consumed the event
    true
  }
}



