package com.xebialabs.xlrelease.webhooks.task.script

import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.script.builder.{ScriptContextBuilder, _}
import com.xebialabs.xlrelease.script.{XlrScript, XlrScriptContext}
import com.xebialabs.xlrelease.webhooks.task.script.ReactiveEventFilterScriptContextBuilder.libraries
import com.xebialabs.xlrelease.webhooks.untyped.EventContentParser

import javax.script.ScriptContext
import scala.jdk.CollectionConverters._

object ReactiveEventFilterScriptContextBuilder {
  val libraries: Seq[String] = Seq(
    "webhook/JsonSugar.py",
    "webhook/eventGlobals.py"
  )
}

class ReactiveEventFilterScriptContextBuilder(task: CustomScriptTask,
                                              event: Event,
                                              eventParser: EventContentParser,
                                              script: String) extends ScriptContextBuilder {
  withLogger()
  withExecutionId(task.getExecutionId)
  withScriptApi()
  withPythonReleaseApi()
  withPythonSugar()
  withPythonUtilities()

  override protected def doBuild(context: XlrScriptContext): Unit = {
    // task properties
    val pythonScript = task.getPythonScript
    val inputProperties = pythonScript.getInputProperties.asScala
    val transitionalProperties = pythonScript.getTransitionalProperties.asScala
    val outputProperties = if (task.hasNextScriptToExecute) {
      pythonScript.getOutputProperties.asScala
    } else {
      Seq()
    }
    val ctxProperties = inputProperties ++ transitionalProperties ++ outputProperties
    context.addDomainObjects(task)
    context.addProperties(pythonScript, ctxProperties.asJavaCollection)
    context.addPropertyBindings(pythonScript.getTransitionalAndOutputProperties)

    // event properties
    eventParser.parse(event).asScala.foreach {
      case (key, value) => addProperty(context, key, value)
    }

    // scripts
    libraries.foreach { source =>
      context.addScript(XlrScript.byResource(source, false, false))
    }
    context.addScript(
      XlrScript.byContent(name = s"<reactive_filter>${task.getTaskType}[${task.getId}]",
        content = script, wrap = false, checkPermissions = true)
    )
  }

  private def addProperty(context: ScriptContext, name: String, value: Any): Unit = {
    context.setAttribute(name, value, ScriptContext.ENGINE_SCOPE)
  }

}
