package com.xebialabs.xlrelease.webhooks.service

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.service.ExecutionDataFinder
import com.xebialabs.xlrelease.webhooks.repository.persistence.CiEventRecordsPersistence
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class CiEventRecordsDataFinder @Autowired()(ciEventRecordsPersistence: CiEventRecordsPersistence) extends ExecutionDataFinder {
  override def supports(dataId: CiId): Boolean = {
    Ids.normalizeId(dataId).startsWith(Type.valueOf(classOf[Event]).getName)
  }

  override def find(dataId: CiId): Option[String] = {
    ciEventRecordsPersistence.findByEventId(dataId).map(_.content)
  }
}
