package com.xebialabs.xlrelease.webhooks.configuration

import com.xebialabs.xlrelease.spring.config.{SqlConfiguration, SqlPersistenceConfiguration, SqlRepositoriesConfiguration}
import com.xebialabs.xlrelease.webhooks.registry.{EndpointRegistry, SubscriberRegistry}
import com.xebialabs.xlrelease.webhooks.repository.persistence.WebhookEndpointInterceptor
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class WebhookConfiguration(sqlRepositories: SqlRepositoriesConfiguration,
                           sqlConfiguration: SqlConfiguration,
                           sqlPersistenceConfiguration: SqlPersistenceConfiguration) {

  @Bean
  def endpointRegistry: EndpointRegistry = {
    val endpointRegistry = EndpointRegistry(
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect(),
      sqlPersistenceConfiguration.sqlRepositoryAdapter()
    )
    endpointRegistry
  }

  @Bean
  def webhookEndpointInterceptor(subscriberRegistry: SubscriberRegistry): WebhookEndpointInterceptor = {
    val interceptor = new WebhookEndpointInterceptor(
      sqlRepositories.cachingConfigurationRepository(),
      sqlPersistenceConfiguration.configurationPersistence(),
      subscriberRegistry,
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect()
    )
    interceptor
  }


}
