package com.xebialabs.xlrelease.webhooks.registry

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.{EventConsumer, EventSource}
import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._


@Component
class RestoreSubscriberRegistry @Autowired()(val subscriberRegistry: SubscriberRegistry,
                                             val configurationRepository: ConfigurationRepository) extends SubscriptionInitializer {

  override def initialize(): Unit = {
    for {
      consumer <- configurationRepository.findAllByType[EventConsumer with Configuration](Type.valueOf(classOf[EventConsumer])).asScala
      if consumer != null && (consumer.eventSource: EventSource) != null
      if consumer.consumerEnabled
    } {
      subscriberRegistry.subscribe((consumer.eventSource: EventSource).sourceId, consumer)
    }
  }

}
