package com.xebialabs.xlplatform.webhooks.events.handlers

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventConsumer}
import grizzled.slf4j.Logging


trait EventConsumerHandler[E <: Event, -C <: EventConsumer] {
  self: Logging =>

  def consumerConfigType: Type

  def consumeEvent(config: C, event: E): Boolean

  def filter(config: C, event: E): Boolean = true

  // TODO there is no value in Boolean returned here - it's ignored!
  //  if we follow execution stack it means there is no value of returning it via consumeEvent etc.
  //  all we have to do is throw an exception if we want to log a warning that consumer was unable to process an event
  def consume(config: C, event: E): Boolean = {
    logger.debug(s"consume($config, $event)")
    logger.trace(s"subtypes of event.getType (${event.getType}): ${DescriptorRegistry.getSubtypes(event.getType)}")
    logger.trace(s"subtypes of config.inputType (${config.inputType}): ${DescriptorRegistry.getSubtypes(config.inputType)}")
    if (config.consumerEnabled) {
      if (config.inputType == null || event.getType.instanceOf(config.inputType)) {
        if (filter(config, event)) {
          logger.trace("types check, consumeEvent()")
          consumeEvent(config, event)
        } else {
          logger.trace("filter returned false, ignoring event")
          false
        }
      } else {
        logger.warn(s"types mismatch on consumer ${config.consumerId}, expected ${config.inputType}, got ${event.getType}")
        false
      }
    } else {
      logger.trace(s"consumer ${config.consumerId} disabled, ignoring event ${event.getId}")
      false
    }
  }
}
