package com.xebialabs.xlrelease.webhooks.consumers.logging

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlplatform.webhooks.events.handlers.EventConsumerHandler
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class LoggingConsumerHandler(val eventBus: XLReleaseEventBus)
  extends EventConsumerHandler[Event, SpyConsumer]
  with Logging {

  override def consumeEvent(config: SpyConsumer, event: Event): Boolean = {
    eventBus.publish(
      EventDispatcherEvent(
        s"sourceId: ${event.sourceId}",
        s" event: ${event.getType}"
      ))
    true
  }

  override def consumerConfigType: Type = Type.valueOf(classOf[SpyConsumer])

}
