package com.xebialabs.xlrelease.webhooks.task

import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
@EventListener
class ReactiveTaskLifecycle @Autowired()(val subscriberRegistry: SubscriberRegistry) extends ReactiveTaskSubscriber {

  @Subscribe
  def onTaskExecution(event: TaskExecutionEvent): Unit = if (isReactiveTask(event.task)) {
    event match {
      case _: TaskStartedEvent | _: TaskRetriedEvent =>
        register(event.task)
      case _: TaskCompletedEvent | _: TaskAbortedEvent | _: TaskSkippedEvent | _: TaskFailedEvent =>
        unregister(event.task)
      case _ => // noop
    }
  }

}
