package com.xebialabs.xlrelease.plugin.manager.db

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.plugin.manager.startup.PluginInserter
import com.xebialabs.xlrelease.db.LiquibaseSupport
import com.xebialabs.xlrelease.spring.config.SqlConfiguration.XLR_REPOSITORY_DATA_SOURCE
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_PLUGIN_MANAGER
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}

import javax.sql.DataSource

class XlrPluginManagerDbInitializer extends BaseInitializingUpgrade with ClassNameToString with LiquibaseSupport with Logging {

  @Autowired
  @Qualifier(XLR_REPOSITORY_DATA_SOURCE)
  var dataSource: DataSource = _

  @Autowired
  var pluginsInserter: PluginInserter = _

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_PLUGIN_MANAGER, "10.2.0#0")

  override def doUpgrade(): Boolean = {
    debug("Running liquibase migration for the plugin manager module.")
    doWithLiquibase("com/xebialabs/plugin/manager/db/10.2.0/xl-plugin-manager-schema.yaml") { liquibase =>
      liquibase.update("")
    }

    debug("inserting all plugins from plugins folder into database")
    pluginsInserter.insertAllPluginsFromFsIntoDb()
    true
  }

}