package com.xebialabs.xlrelease.plugin.manager

import com.xebialabs.deployit.plumbing.CurrentVersion
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository
import com.xebialabs.plugin.manager.scheduler.PluginRepositoryUpdateScheduler
import com.xebialabs.plugin.manager.service.LocalPluginService
import com.xebialabs.plugin.manager.startup.{PluginInserter, PluginUpgrader}
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.context.annotation.{Bean, ComponentScan, Configuration}
import org.springframework.jdbc.core.JdbcTemplate

@Configuration
@ComponentScan(basePackages = Array("com.xebialabs.plugin.manager.rest", "com.xebialabs.plugin.manager.event"))
class XlrPluginManagerConfiguration(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate) {

  @Bean
  def xlrPluginManagerProperties(): XlrPluginManagerProperties = new XlrPluginManagerProperties()

  @Bean
  def sqlPluginRepository(): SqlPluginRepository = new SqlPluginRepository(jdbcTemplate)

  @Bean
  def localPluginManager(sqlPluginRepository: SqlPluginRepository): LocalPluginService = new LocalPluginService(
    xlrPluginManagerProperties(),
    "xl-release",
    CurrentVersion.get,
    sqlPluginRepository
  )

  @Bean
  def pluginInserter(sqlPluginRepository: SqlPluginRepository): PluginInserter = new PluginInserter(sqlPluginRepository, "xl-release")

  @Bean
  def pluginUpgrader(sqlPluginRepository: SqlPluginRepository): PluginUpgrader = new PluginUpgrader(sqlPluginRepository, "xl-release")

  @Bean
  def pluginRepositoryUpdateScheduler(localPluginService: LocalPluginService): PluginRepositoryUpdateScheduler = new PluginRepositoryUpdateScheduler(localPluginService)

}

