package com.xebialabs.xlrelease.plugin.manager

import com.xebialabs.deployit.plumbing.CurrentVersion
import com.xebialabs.plugin.manager.metadata.Version
import com.xebialabs.plugin.manager.metadata.XLProduct.XLRelease
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository
import com.xebialabs.plugin.manager.scheduler.PluginRepositoryUpdateScheduler
import com.xebialabs.plugin.manager.service.LocalPluginService
import com.xebialabs.plugin.manager.startup.{PluginInserter, PluginReloader, PluginUpgrader}
import com.xebialabs.plugin.manager.validator.TypeSystemValidator
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.events.EventBus
import com.xebialabs.xlrelease.plugin.manager.validator.XlrPluginManagerProperties
import com.xebialabs.xlrelease.service.BroadcastService
import org.springframework.context.ApplicationEventPublisher
import org.springframework.context.annotation.{Bean, ComponentScan, Configuration}

@Configuration
@ComponentScan(basePackages = Array("com.xebialabs.plugin.manager.rest", "com.xebialabs.plugin.manager.event"))
class XlrPluginManagerConfiguration(val eventBus: EventBus,
                                    sqlPluginRepository: SqlPluginRepository,
                                    typeSystemValidator: TypeSystemValidator,
                                    broadcastService: BroadcastService,
                                    eventPublisher: ApplicationEventPublisher
                                   ) {

  @Bean
  def xlrPluginManagerProperties(): XlrPluginManagerProperties = new XlrPluginManagerProperties()

  @Bean
  def pluginReloader(): PluginReloader = {
    new XlrPluginReloader(broadcastService)
  }

  @Bean
  def localPluginManager(): LocalPluginService = new LocalPluginService(
    xlrPluginManagerProperties(),
    XLRelease,
    Version.fromString(CurrentVersion.get).get,
    sqlPluginRepository,
    XlrConfig.getInstance.features.plugins.checkJdk17CompatibilityOnPluginInstall,
    typeSystemValidator,
    pluginReloader(),
    eventPublisher
  )

  @Bean
  def pluginInserter(): PluginInserter = new PluginInserter(sqlPluginRepository, "xl-release")

  @Bean
  def pluginUpgrader(): PluginUpgrader = new PluginUpgrader(sqlPluginRepository, "xl-release")

  @Bean
  def pluginRepositoryUpdateScheduler(localPluginService: LocalPluginService): PluginRepositoryUpdateScheduler = new PluginRepositoryUpdateScheduler(localPluginService)

}

