package com.xebialabs.xlrelease.plugin.manager

import com.xebialabs.plugin.manager.Plugin
import com.xebialabs.plugin.manager.startup.PluginReloader
import com.xebialabs.xlrelease.events.system.distributed.ReloadPlugin
import com.xebialabs.xlrelease.service.BroadcastService
import grizzled.slf4j.Logging

class XlrPluginReloader(broadcastService: BroadcastService)
  extends PluginReloader with Logging {

  override def reloadPlugin(plugin: Plugin): Unit = {
    // TODO S-89678 make this reload process reliable
    //  - either make sure all nodes have to reload before we continue?
    //  - or let nodes detect that there is change in the database and heal themselves
    //  - or if nodes cannot reload - let them stop?
    broadcastService.broadcast(ReloadPlugin(plugin.id), true)
  }

}
