#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from ansiblecontroller import AAPServer
import time
import sys

if not ansibletower:
    print("Ansible Automation Platform Controller Server must be provided")
    sys.exit(1)

if wait_interval is None:
    print("Wait interval must be provided")
    sys.exit(1)

ansible_instance = AAPServer(ansibletower, username, password, apiToken)
request = ansible_instance.create_request()
headers = ansible_instance.create_header()

waiting_time = int(wait_interval)
job_id = None

if not isWorkflow:
    api_url = '/api/controller/v2/job_templates/%s/launch/' % job_template_id
    body = {"extra_vars": extra_vars}
    response = request.post(api_url, body=json.dumps(body), contentType="application/json", headers=headers)
    # Check the response status code to make sure the request was not successful.
    if not response.isSuccessful():
        print("Failed to run the job template. Server return [%s], with content [%s]" % (
        response.status, response.response))
        sys.exit(1)

    result = json.loads(response.response)
    job_id = result["id"]
    print("Job template launched with job id  " + str(job_id))
    print("\n")
    task.schedule("ansiblecontroller/LaunchWaitSchedule.py", waiting_time)

else:
    api_url = '/api/controller/v2/workflow_job_templates/%s/launch/' % job_template_id
    body = {"extra_vars": extra_vars}
    response = request.post(api_url, body=json.dumps(body), contentType="application/json", headers=headers)
    # Check the response status code to make sure the request was not successful.
    if not response.isSuccessful():
        print("Failed to run the workflow job template. Server return [%s], with content [%s]" % (
        response.status, response.response))
        sys.exit(1)
    result = json.loads(response.response)
    job_id = result["id"]
    print("Job template launched with job id  " + str(job_id))
    print("\n")
    task.schedule("ansiblecontroller/LaunchWorkflowWaitSchedule.py", waiting_time)
