#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from xlrelease.HttpRequest import HttpRequest
from ansiblecontroller import AAPServer

if not ansibletower:
    raise Exception("Ansible Tower Server  must be provided")

ansible_instance = AAPServer(ansibletower,username,password,apiToken)
request = ansible_instance.create_request()
headers = ansible_instance.create_header()


response = request.get(Endpoint, contentType='application/json',headers=headers)

# Check the response status code to make sure the request was not successful.
if not response.isSuccessful():
    raise Exception("Failed to get information. Server return [%s], with content [%s]" % (response.status, response.response))

result = json.loads(response.response)

