#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from xlrelease.HttpRequest import HttpRequest
from ansiblecontroller import AAPServer

if not ansibletower:
    raise Exception("Ansible Automation Platform Controller Server must be provided")
ansible_instance = AAPServer(ansibletower,username,password,apiToken)
request = ansible_instance.create_request()
headers = ansible_instance.create_header()

if not isWorkflow:
  api_url = '/api/controller/v2/job_templates/%s/launch/' % job_template_id
  body = {"extra_vars": extra_vars}
  response = request.post(api_url,body= json.dumps(body),contentType="application/json",headers=headers)
  # Check the response status code to make sure the request was not successful.
  if not response.isSuccessful():
    raise Exception("Failed to run the job template. Server return [%s], with content [%s]" % (response.status, response.response))
  result = json.loads(response.response)
  job_id= result["id"]
  print("[Job : %s](%s/execution/jobs/playbook/%s/output)" % (str(job_id), str(ansibletower['url']).rstrip('/'), str(job_id)))

else:
  api_url = '/api/controller/v2/workflow_job_templates/%s/launch/' % job_template_id
  body = {"extra_vars": extra_vars}
  response = request.post(api_url,body= json.dumps(body),contentType="application/json",headers=headers)
  # Check the response status code to make sure the request was not successful.
  if not response.isSuccessful():
    raise Exception("Failed to run the workflow job template. Server return [%s], with content [%s]" % (response.status, response.response))
  result = json.loads(response.response)
  job_id= result["id"]
  print("[Workflow job : %s](%s/execution/jobs/workflow/%s/output)" % (str(job_id), str(ansibletower['url']).rstrip('/'), str(job_id)))


