#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient
from argocd.status import map_application_deployment_package_states, map_cluster_names

if not connectionServer:
    raise Exception("ArgoCD server must be provided to script")

if not connection:
    raise Exception("ArgoCD connection must be provided to script")

client = RestClient(argo_server=connectionServer)
clusters = map_cluster_names(client.listClusters(), connectionServer['title'])
applications = client.listApplications(connection['filteredFolders'])

data = map_application_deployment_package_states(applications, clusters)
