/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.config;

import com.xebialabs.deployit.plumbing.authentication.RedirectToUrlSuccessHandler;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.platform.sso.crypto.KeyRetriever;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToUserPolicy;
import com.xebialabs.platform.sso.oidc.web.OpenIdLogoutSuccessHandler;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.policy.impl.DefaultOidcUserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.web.XlReleaseLoginFormFilter;
import com.xebialabs.xlrelease.auth.oidc.web.XlReleaseOpenIdConnectFilter;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.XlReleaseOpenIdLoginFailureHandler;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.XlReleaseOpenIdLogoutSuccessHandler;
import com.xebialabs.xlrelease.security.IdentityProvider;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import scala.concurrent.duration.Duration;

@Configuration
@EnableOAuth2Client
public class OpenIdConnectConfig {
    public static final String OIDC_LOGIN = "/oidc-login";
    public static final String INTERNAL_USER_LOGIN_SUCCESS_URL = "#/login?reloadUserDetails";
    public static final String DEFAULT_LOGIN_URL = "/login";
    @Value(value="${xl.security.auth.providers.oidc.clientId}")
    private String clientId;
    @Value(value="${xl.security.auth.providers.oidc.issuer}")
    private String issuer;
    @Value(value="${xl.security.auth.providers.oidc.clientSecret}")
    private String clientSecret;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalUri}")
    private String keyRetrievalUri;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalSchedule:24 hours}")
    private String keyRetrievalSchedule;
    @Value(value="${xl.security.auth.providers.oidc.accessTokenUri}")
    private String accessTokenUri;
    @Value(value="${xl.security.auth.providers.oidc.userAuthorizationUri}")
    private String userAuthorizationUri;
    @Value(value="${xl.security.auth.providers.oidc.logoutUri}")
    private String logoutUri;
    @Value(value="${xl.security.auth.providers.oidc.redirectUri}")
    private String redirectUri;
    @Value(value="${xl.security.auth.providers.oidc.rolesClaim}")
    private String rolesClaim;
    @Value(value="${xl.security.auth.providers.oidc.fullNameClaim}")
    private String fullNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.userNameClaim}")
    private String userNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.emailClaim}")
    private String emailClaim;
    @Value(value="${xl.security.auth.providers.oidc.scopes}")
    private String scopes;

    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProvider("oidc", "./oidc-login", "./logout");
    }

    @Bean
    @Autowired
    public XlReleaseOpenIdConnectFilter openIdConnectFilter(AuthenticationManager authenticationManager, OAuth2ClientContext oAuth2ClientContext, Scheduler scheduler, UserProfileCreationPolicy userProfileCreationPolicy, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        KeyRetriever keyRetriever = new KeyRetriever(this.keyRetrievalUri);
        long interval = Duration.apply((String)this.keyRetrievalSchedule).toMinutes();
        scheduler.scheduleAtFixedRate(() -> ((KeyRetriever)keyRetriever).refreshKeys(), interval, interval, TimeUnit.MINUTES);
        XlReleaseOpenIdConnectFilter filter = new XlReleaseOpenIdConnectFilter(OIDC_LOGIN, this.clientId, this.issuer, this.openIdTemplate(oAuth2ClientContext), keyRetriever, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy, userProfileCreationPolicy);
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationFailureHandler(this.openIdLoginFailureHandler());
        return filter;
    }

    @Bean
    public OAuth2ProtectedResourceDetails openIdDetails() {
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setUserAuthorizationUri(this.userAuthorizationUri);
        details.setScope(Stream.of(this.scopes.split(",")).collect(Collectors.toList()));
        if (this.redirectUri.isEmpty()) {
            details.setUseCurrentUri(true);
        } else {
            details.setPreEstablishedRedirectUri(this.redirectUri);
            details.setUseCurrentUri(false);
        }
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return details;
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(OIDC_LOGIN);
    }

    @Bean
    public OAuth2RestTemplate openIdTemplate(OAuth2ClientContext clientContext) {
        return new OAuth2RestTemplate(this.openIdDetails(), clientContext);
    }

    @Bean
    @Autowired
    public UserProfileCreationPolicy userProfileCreationPolicy(UserProfileService userProfileService, UserService userService) {
        return new DefaultOidcUserProfileCreationPolicy(userProfileService, userService, this.emailClaim, this.fullNameClaim);
    }

    @Bean
    public ClaimsToUserNamePolicy claimsToUserNamePolicy() {
        return new DefaultClaimsToUserPolicy(this.userNameClaim);
    }

    @Bean
    public ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.rolesClaim);
    }

    @Bean
    public OpenIdLogoutSuccessHandler openIdLogoutSuccessHandler() {
        return new XlReleaseOpenIdLogoutSuccessHandler(this.logoutUri);
    }

    @Bean
    public XlReleaseOpenIdLoginFailureHandler openIdLoginFailureHandler() {
        return new XlReleaseOpenIdLoginFailureHandler();
    }

    @Bean
    @Autowired
    public XlReleaseLoginFormFilter xlReleaseLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        XlReleaseLoginFormFilter filter = new XlReleaseLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new RedirectToUrlSuccessHandler(INTERNAL_USER_LOGIN_SUCCESS_URL));
        filter.setAuthenticationFailureHandler(this.openIdLoginFailureHandler());
        return filter;
    }

    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "static/0/styles/img/xl-release-logo-white.svg");
        scope.put("productColor", "#68B749");
        scope.put("productIcon", "static/7.1.0/styles/img/favicon.ico");
        scope.put("productName", "XL Release");
        return scope;
    }
}

