/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 3);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _spnegoLoginController = __webpack_require__(2);

var _spnegoLoginController2 = _interopRequireDefault(_spnegoLoginController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LOGIN_URL = '/login/spnego';

var _module = angular.module('xlrelease.auth.spnego', ['xlrelease', 'ui.router']);
_module.controller('spnegoLoginController', _spnegoLoginController2.default);

_module.config(['$stateProvider', function ($stateProvider) {
    $stateProvider.state('loginSpnego', {
        url: LOGIN_URL,
        reloadOnSearch: false,
        templateUrl: 'static/@project.version@/include/auth/spnego/spnego-login.html',
        controller: 'spnegoLoginController',
        controllerAs: '$ctrl',
        resolve: {}
    });
}]);

_module.run(['$state', '$location', '$window', 'AuthenticationRegistry', 'RedirectOnLoginService', 'PageUrls', function ($state, $location, $window, AuthenticationRegistry, RedirectOnLoginService, PageUrls) {
    var isWindows = _.includes($window.navigator.appVersion, 'Win');
    AuthenticationRegistry.provider('spnego', {
        order: 9,
        autoLogin: isWindows,
        formLogin: isWindows,
        loginLabel: 'Log in with Windows',
        loginCss: 'windows-login',
        login: function login(isAutoLogin) {
            var currentPath = $location.path();
            if (isAutoLogin && currentPath === PageUrls.LOGIN_PAGE) {
                return false;
            } else if (isAutoLogin && currentPath === LOGIN_URL) {
                return true;
            } else {
                RedirectOnLoginService.registerRequestedURL();
                $state.go('loginSpnego');
                return true;
            }
        }
    });
}]);

/***/ }),
/* 1 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SpnegoLoginController = function () {
    function SpnegoLoginController(Backend, Authenticator) {
        _classCallCheck(this, SpnegoLoginController);

        this.Backend = Backend;
        this.Authenticator = Authenticator;
    }

    _createClass(SpnegoLoginController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loginInProgress = true;
            setTimeout(function () {
                return _this.Backend.get('/login/spnego').then(function (response) {
                    _this.loginInProgress = false;
                    _this.loggedIn = true;
                    _this.user = response.data;
                    setTimeout(function () {
                        return _this.Authenticator.loadUserDetails(_this.user.username);
                    }, 2000);
                }).catch(function () {
                    _this.loginInProgress = false;
                    _this.loggedIn = false;
                });
            }, 2000);
        }
    }]);

    return SpnegoLoginController;
}();

exports.default = SpnegoLoginController;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(0);

__webpack_require__(1);

/***/ })
/******/ ]);