#
# Copyright 2017 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

import com.xhaus.jyson.JysonCodec as json
from xlrelease.HttpRequest import HttpRequest
from azure import AzureServer
from azure.util import error

url = "%s/%s" % (configuration.url, configuration.organization)
# get the configuration properties from the UI
if configuration.authenticationMethod == 'OAuth2':
   if not configuration.tenantId or not configuration.clientId or not configuration.clientSecret:
      error("Client ID or Client Secret or Tenant ID cannot be empty")
   access_token_url = "https://login.microsoftonline.com/%s/oauth2/v2.0/token" % configuration.tenantId
   params_oauth = {'url': configuration.url, 'accessTokenUrl': access_token_url,
          'clientId': configuration.clientId, 'clientSecret': configuration.clientSecret,
          'scope': configuration.scope, 'proxyHost': configuration.proxyHost,
          'proxyPort': configuration.proxyPort, 'proxyUsername': configuration.proxyUsername,
          'proxyPassword': configuration.proxyPassword}
   
   configuration.password = AzureServer.get_access_token(params_oauth)
   configuration.authenticationMethod = 'Bearer'

params = { 'url': url, 'password': configuration.password, 'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort, 'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword, 'authenticationMethod': configuration.authenticationMethod }

# execute http request to the server
response = HttpRequest(params).get('/_apis/projects?api-version=7.1-preview.4', contentType = 'application/json')

# check response status code, if is different from 200 exit with error code
if response.status != 200:
    error("Couldn't establish the connection with server.", response)

# TODO validate if this is necessary
projectCount = int(json.loads(response.response)['count'])

if projectCount == 0:
    error("No projects found.")
