/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.azure;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyvaultHelper {
    private static final Logger logger = LoggerFactory.getLogger(KeyvaultHelper.class);
    private String subscriptionId;
    private String tenantId;
    private String clientId;
    private String clientKey;
    private String userName;
    private String userPassword;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String authenticationMethod;
    private boolean verifySSL;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public KeyvaultHelper(String tenantId, String clientId, String clientKey, String subscriptionId, String proxyHost, String proxyPort, String proxyUser, String proxyPassword, String authenticationMethod, boolean verifySSL) {
        this.subscriptionId = subscriptionId;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientKey = clientKey;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.authenticationMethod = authenticationMethod;
        this.verifySSL = verifySSL;
    }

    public KeyvaultHelper(String userName, String userPassword, String subscriptionId, String proxyHost, String proxyPort, String proxyUser, String proxyPassword, String authenticationMethod, boolean verifySSL) {
        this.subscriptionId = subscriptionId;
        this.userName = userName;
        this.userPassword = userPassword;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.authenticationMethod = authenticationMethod;
        this.verifySSL = verifySSL;
    }

    public HttpResponse<String> executeTokenRequest(String authenticationMethod) throws NoSuchAlgorithmException, KeyManagementException {
        HttpClient client = this.getClientWithProxy();
        HashMap<Object, Object> datas = new HashMap<Object, Object>();
        if (authenticationMethod.equalsIgnoreCase("Directory_Application_And_Service_Principal")) {
            datas.put("grant_type", "client_credentials");
            datas.put("client_id", this.clientId);
            datas.put("client_secret", this.clientKey);
            datas.put("scope", "https://vault.azure.net/.default");
        } else {
            datas.put("grant_type", "password");
            datas.put("password", this.userPassword);
            datas.put("username", this.userName);
            datas.put("client_id", "04b07795-8ddb-461a-bbee-02f9e1bf7b46");
            datas.put("scope", "https://vault.azure.net/.default");
        }
        String boundary = new BigInteger(256, new Random()).toString();
        String url = "https://login.microsoftonline.com/" + this.tenantId + "/oauth2/v2.0/token";
        try {
            HttpRequest request = HttpRequest.newBuilder(URI.create(url)).header("accept", "application/json").header("Content-Type", "multipart/form-data;boundary=" + boundary).POST(this.ofMimeMultipartData(datas, boundary)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 400) {
                logger.error("An error occurred when request is executed : " + response.body());
                throw new Exception("An error occurred when request is executed");
            }
            return response;
        }
        catch (Exception e) {
            logger.error("An error occurred when request is executed", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<String> executeRequest(String method, String vaultName, String secretName, String secretValue) throws Exception {
        try {
            HttpResponse<String> responseForToken = this.executeTokenRequest(this.authenticationMethod.toString());
            if (responseForToken.statusCode() >= 400) {
                throw new Exception("Unable to Get Access Token ");
            }
            String token = this.parseTokenResponse(responseForToken.body(), "access_token");
            HttpClient client = this.getClientWithProxy();
            String url = "https://" + vaultName + ".vault.azure.net/secrets/" + secretName + "?api-version=7.4";
            HttpRequest request = null;
            String bearerToken = "Bearer " + token;
            if (method.equalsIgnoreCase("get")) {
                request = HttpRequest.newBuilder(URI.create(url)).header("accept", "application/json").header("Authorization", bearerToken).GET().build();
            } else if (method.equalsIgnoreCase("create")) {
                request = HttpRequest.newBuilder(URI.create(url)).header("Content-Type", "application/json").header("accept", "application/json").header("Authorization", bearerToken).PUT(HttpRequest.BodyPublishers.ofString(this.getRequestData(secretValue))).build();
            } else if (method.equalsIgnoreCase("delete")) {
                request = HttpRequest.newBuilder(URI.create(url)).header("accept", "application/json").header("Authorization", bearerToken).DELETE().build();
            } else {
                logger.error("Method Not found");
            }
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response;
        }
        catch (Exception e) {
            logger.error("An error occurred when request is executed : ", (Throwable)e);
            throw new Exception("An error occurred when request is executed : " + e.getMessage());
        }
    }

    public String parseTokenResponse(String jsonData, String tokenToParse) throws Exception {
        try {
            ObjectMapper obj = new ObjectMapper();
            JsonFactory factory = obj.getFactory();
            JsonParser parser = factory.createParser(jsonData);
            JsonNode node = (JsonNode)obj.readTree(parser);
            JsonNode node1 = node.get(tokenToParse);
            return node1.textValue();
        }
        catch (Exception e) {
            logger.error("An error occurred when response is parsed", (Throwable)e);
            throw new Exception("An error occurred when response is parsed");
        }
    }

    public String getRequestData(String value) {
        String jsonString = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            rootNode.put("value", value);
            jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
            return jsonString;
        }
        catch (Exception e) {
            logger.error("An error occurred when request is being built", (Throwable)e);
            return jsonString;
        }
    }

    public String checkConn() throws Exception {
        String token = null;
        try {
            token = this.executeTokenRequest(this.authenticationMethod.toString()).body();
        }
        catch (Exception e) {
            logger.error("Connection could not be established. ", (Object)e.getMessage());
            throw new Exception("Connection could not be established. Please verify your credentials.");
        }
        return token;
    }

    public void createSecret(String vaultName, String secretName, String secretValue) throws Exception {
        HttpResponse<String> secretResponse = this.executeRequest("create", vaultName, secretName, secretValue);
        if (secretResponse.statusCode() > 400) {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(secretResponse.body(), Map.class);
            HashMap hm = (HashMap)map.get("error");
            throw new Exception("Unable to Set Secret : " + secretName + "  Reason : " + hm.get("message"));
        }
    }

    public void deleteSecret(String vaultName, String secretName) throws Exception {
        HttpResponse<String> secretResponse = this.executeRequest("delete", vaultName, secretName, "");
        if (secretResponse.statusCode() > 400) {
            throw new Exception("Unable to Delete Secret : " + secretName);
        }
    }

    public String getSecret(String vaultName, String secretName) throws Exception {
        HttpResponse<String> secretValueResponse = this.executeRequest("get", vaultName, secretName, "");
        String secretValue = null;
        if (secretValueResponse.statusCode() > 400) {
            throw new Exception("Unable to get Secret : " + secretName);
        }
        secretValue = this.parseTokenResponse(secretValueResponse.body(), "value");
        return secretValue;
    }

    public HttpClient getClientWithProxy() throws NoSuchAlgorithmException, KeyManagementException {
        HttpClient.Builder httpBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(60L));
        int proxyPortNumber = 0;
        if (this.proxyHost != null && this.proxyPort != null) {
            proxyPortNumber = Integer.parseInt(this.proxyPort);
            Authenticator authenticator = null;
            if (this.proxyUser != null && this.proxyPassword != null) {
                authenticator = new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(KeyvaultHelper.this.proxyUser, KeyvaultHelper.this.proxyPassword.toCharArray());
                    }
                };
                httpBuilder.authenticator(authenticator);
            }
            httpBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyHost, proxyPortNumber)));
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        if (this.verifySSL) {
            return httpBuilder.build();
        }
        System.out.println("Turning off SSL Verification");
        return httpBuilder.sslContext(sslContext).build();
    }

    public HttpRequest.BodyPublisher ofMimeMultipartData(Map<Object, Object> data, String boundary) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] separator = ("--" + boundary + "\r\nContent-Disposition: form-data; name=").getBytes(StandardCharsets.UTF_8);
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            byteArrays.add(separator);
            byteArrays.add(("\"" + entry.getKey() + "\"\r\n\r\n" + entry.getValue() + "\r\n").getBytes(StandardCharsets.UTF_8));
        }
        byteArrays.add(("--" + boundary + "--").getBytes(StandardCharsets.UTF_8));
        return HttpRequest.BodyPublishers.ofByteArrays(byteArrays);
    }

    public boolean isNotEmpty(String inputValue) {
        return inputValue != null && inputValue.length() > 0;
    }
}

