#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from com.xebialabs.xlrelease.plugin.azure import KeyvaultHelper

class AzureConnector(object):
    azureKeyvaultHelper = None
    def __init__(self, container):
        if container['authenticationMethod']:
            authMethod = str(container['authenticationMethod'])
        if authMethod == 'Active_Directory_With_Username_And_Password':
            if (not container["userName"]) or (not container["userPassword"]):
                raise Exception('For Active Directory With Username And Password \
                                 authentication parameters username \
                                 and Password are required')
            else:
                self.azureKeyvaultHelper = KeyvaultHelper(container["userName"], container["userPassword"], container["subscriptionId"],
                                                          container["proxyHost"], container["proxyPort"], container["proxyUser"],
                                                          container["proxyPassword"], authMethod, container["verifySSL"])

        elif authMethod == 'Directory_Application_And_Service_Principal':
            if (not container["clientId"]) or (not container["clientKey"]) or (not container["tenantId"]):
                raise Exception('For Directory Application And Service Principal \
                                 authentication parameters clientId, clientKey,\
                                 tenantId are required')
            else:
                self.azureKeyvaultHelper = KeyvaultHelper(container["tenantId"],container["clientId"], container["clientKey"],
                                                          container["subscriptionId"], container["proxyHost"], container["proxyPort"],
                                                          container["proxyUser"],container["proxyPassword"], authMethod, container["verifySSL"])

        else:
            raise Exception('Authentication method {0} not supported'.format(authMethod))

    def keyvault_get_secret(self, vaultName, secretName):
        return self.azureKeyvaultHelper.getSecret(vaultName, secretName)

    def keyvault_check_connection(self):
        return self.azureKeyvaultHelper.checkConn()

    def keyvault_create_secret(self, vaultName, secretName, secretValue):
        return self.azureKeyvaultHelper.createSecret(vaultName, secretName, secretValue)

    def keyvault_delete_secret(self, vaultName, secretName):
        return self.azureKeyvaultHelper.deleteSecret(vaultName, secretName)