/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.azure;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.plugin.azure.KeyvaultHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyvaultServer
extends ExternalVariableServer {
    private static final Logger logger = LoggerFactory.getLogger(KeyvaultServer.class);
    @Property(description="AuthenticationMethod DependentProperties", required=false, hidden=true, defaultValue="Directory_Application_And_Service_Principal:tenantId;clientId;clientKey,Active_Directory_With_Username_And_Password:tenantId;userName;userPassword", category="Authentication")
    private Map<String, String> authenticationMethod_DependentProperties;
    @Property(label="Authentication Method", required=false, defaultValue="Directory_Application_And_Service_Principal")
    private AuthenticationMethod authenticationMethod;
    @Property(description="Script Location", required=false, hidden=true, defaultValue="azurekeyvaults/check_connection.py")
    private String scriptLocation;
    @Property(required=false, description="Active Directory UserName to use for the account", category="Authentication")
    private String userName;
    @Property(password=true, required=false, description="Active Directory Password to use for the account", category="Authentication")
    private String userPassword;
    @Property(required=false, description="Subscription ID", category="Authentication")
    private String subscriptionId;
    @Property(required=true, description="Tenant ID to use for the account", category="Authentication")
    private String tenantId;
    @Property(password=false, required=false, description="Client ID to use for the account", category="Authentication")
    private String clientId;
    @Property(password=true, required=false, description="Client Key to use for the account", category="Authentication")
    private String clientKey;
    @Property(required=false, label="Proxy Server Host", description="Hostname of the proxy server to use while connecting to Azure.", category="Proxy Settings")
    private String proxyHost;
    @Property(required=false, label="Proxy Server Port", description="Port number of the proxy server to use while connecting to Azure.", category="Proxy Settings")
    private String proxyPort;
    @Property(password=false, required=false, label="Proxy Server Username", description="Username of the proxy server.", category="Proxy Settings")
    private String proxyUser;
    @Property(password=true, required=false, label="Proxy Server Password", description="Password of the proxy server.", category="Proxy Settings")
    private String proxyPassword;
    @Property(description="Hidden as API is used", required=false, hidden=true, defaultValue="locahost")
    private String url;
    @Property(description="Hidden as API is used", password=true, required=false, hidden=true, category="Authentication")
    private String token;
    @Property(description="Verify SSL toggle", label="Verify SSL", required=false, defaultValue="True")
    private boolean verifySSL;

    public Map<String, String> getAuthenticationMethod_DependentProperties() {
        return this.authenticationMethod_DependentProperties;
    }

    public void setAuthenticationMethod_DependentProperties(Map<String, String> authenticationMethod_DependentProperties) {
        this.authenticationMethod_DependentProperties = authenticationMethod_DependentProperties;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean getVerifySSL() {
        return this.verifySSL;
    }

    public void setVerifySSL(boolean verifySSL) {
        this.verifySSL = verifySSL;
    }

    public Map<String, String> lookup(List<PasswordStringVariable> variables) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        try {
            KeyvaultHelper helper = null;
            if (this.authenticationMethod.toString().equalsIgnoreCase("Directory_Application_And_Service_Principal")) {
                String clientKeyValue = PasswordEncrypter.getInstance().ensureDecrypted(this.getClientKey());
                helper = new KeyvaultHelper(this.getTenantId(), this.getClientId(), clientKeyValue, this.getSubscriptionId(), this.getProxyHost(), this.getProxyPort(), this.getProxyUser(), this.getProxyPassword(), this.getAuthenticationMethod().toString(), this.getVerifySSL());
            } else {
                String passwordValue = PasswordEncrypter.getInstance().decrypt(this.getUserPassword());
                helper = new KeyvaultHelper(this.getUserName(), passwordValue, this.getSubscriptionId(), this.getProxyHost(), this.getProxyPort(), this.getProxyUser(), this.getProxyPassword(), this.getAuthenticationMethod().toString(), this.getVerifySSL());
            }
            String vaultName = null;
            String secretName = null;
            String keyValue = null;
            for (PasswordStringVariable var : variables) {
                ExternalVariableValue externalVariableValue = var.getExternalVariableValue();
                secretName = externalVariableValue.getExternalKey();
                vaultName = externalVariableValue.getPath();
                keyValue = helper.getSecret(vaultName, secretName);
                lookupMap.put(var.getKey(), keyValue);
            }
        }
        catch (Exception e) {
            System.out.println("Exception Occurred during lookup");
        }
        return lookupMap;
    }

    public static enum AuthenticationMethod {
        Directory_Application_And_Service_Principal,
        Active_Directory_With_Username_And_Password;

    }
}

